/*
 * Decompiled with CFR 0.152.
 */
package net.tee7even.presents;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.command.CommandSender;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.item.Item;
import cn.nukkit.utils.Config;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.tee7even.presents.Chest;
import net.tee7even.presents.Presents;
import net.tee7even.presents.provider.DataProvider;
import net.tee7even.presents.provider.YamlProvider;
import net.tee7even.presents.utils.Message;

class ChestManager {
    private static DataProvider dataProvider;
    private static List<Chest> chests;
    private static int totalWeight;
    private static Map<Integer, Weight> itemWeights;
    private static Random rng;

    ChestManager() {
    }

    static void init() {
        dataProvider = new YamlProvider();
        chests = dataProvider.loadChests();
        ChestManager.loadWeights();
        Server.getInstance().getScheduler().scheduleDelayedTask(() -> dataProvider.save(), 5000);
    }

    static void place(Player player) {
        int[] faces = new int[]{4, 2, 5, 3};
        chests.add(new Chest(player.getFloorX(), player.getFloorY(), player.getFloorZ(), player.level, faces[player.getDirection().getIndex()]));
        dataProvider.saveChest(player.getFloorX(), player.getFloorY(), player.getFloorZ(), player.level.getName(), faces[player.getDirection().getIndex()]);
        Message.send((CommandSender)player, "place", new String[0]);
    }

    static boolean tryOpen(Player player, Block block) {
        for (Chest chest : chests) {
            if (!chest.blockEquals(block)) continue;
            chest.open(player, ChestManager.getRandomItem());
            return true;
        }
        return false;
    }

    static boolean isChestItemEntity(EntityItem itemEntity) {
        for (Chest chest : chests) {
            if (!chest.itemEntityEquals(itemEntity)) continue;
            return true;
        }
        return false;
    }

    static boolean tryRemove(Player player, Block block) {
        for (int i = 0; i < chests.size(); ++i) {
            if (!chests.get(i).blockEquals(block)) continue;
            if (player.hasPermission("presents")) {
                chests.get(i).close();
                chests.remove(i);
                dataProvider.removeChest(block.x, block.y, block.z, block.level.getName(), block.getDamage());
                Message.send((CommandSender)player, "remove.success", new String[0]);
                return true;
            }
            Message.send((CommandSender)player, "remove.no-permission", new String[0]);
            return false;
        }
        return true;
    }

    static void close() {
        dataProvider.save();
        chests.forEach(Chest::close);
    }

    private static Item getRandomItem() {
        int sum = 0;
        int num = rng.nextInt(totalWeight);
        for (Map.Entry<Integer, Weight> entry : itemWeights.entrySet()) {
            if ((sum += entry.getValue().weight) < num) continue;
            return Item.get((int)entry.getKey(), (Integer)0, (int)(new Random().nextInt(entry.getValue().max - entry.getValue().min + 1) + entry.getValue().min));
        }
        return Item.get((int)0);
    }

    private static void loadWeights() {
        Config weightConfig = new Config(new File(Presents.getPlugin().getDataFolder(), "weights.yml"), 2);
        for (String itemId : weightConfig.getKeys(false)) {
            totalWeight += weightConfig.getSection(itemId).getInt("weight");
            itemWeights.put(Integer.parseInt(itemId), new Weight(weightConfig.getSection(itemId).getInt("weight"), weightConfig.getSection(itemId).getInt("min"), weightConfig.getSection(itemId).getInt("max")));
        }
    }

    static {
        totalWeight = 0;
        itemWeights = new HashMap<Integer, Weight>();
        rng = new Random();
    }

    private static class Weight {
        int weight;
        int min;
        int max;

        Weight(int weight, int min, int max) {
            this.weight = weight;
            this.min = min;
            this.max = max;
        }
    }
}

