/*
 * Decompiled with CFR 0.152.
 */
package net.tee7even.presents.provider;

import cn.nukkit.Server;
import cn.nukkit.utils.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.tee7even.presents.Chest;
import net.tee7even.presents.Presents;
import net.tee7even.presents.provider.DataProvider;

public class YamlProvider
implements DataProvider {
    private Config chestConfig = new Config(new File(Presents.getPlugin().getDataFolder(), "chests.yml"), 2);

    @Override
    public List<Chest> loadChests() {
        ArrayList<Chest> chests = new ArrayList<Chest>();
        Set keys = this.chestConfig.getKeys();
        for (String key : keys) {
            List coordList = this.chestConfig.getStringList(key);
            for (String coords : coordList) {
                String[] str = coords.split(",");
                chests.add(new Chest(Double.parseDouble(str[0]), Double.parseDouble(str[1]), Double.parseDouble(str[2]), Server.getInstance().getLevelByName(key), Integer.parseInt(str[3])));
            }
        }
        return chests;
    }

    @Override
    public void saveChest(double x, double y, double z, String levelName, int facing) {
        String coords = (int)x + "," + (int)y + "," + (int)z + "," + facing;
        ArrayList<String> coordList = this.chestConfig.getStringList(levelName);
        if (coordList == null) {
            coordList = new ArrayList<String>();
        }
        coordList.add(coords);
        this.chestConfig.set(levelName, coordList);
    }

    @Override
    public void removeChest(double x, double y, double z, String levelName, int facing) {
        String coords = (int)x + "," + (int)y + "," + (int)z + "," + facing;
        ArrayList coordList = this.chestConfig.getStringList(levelName);
        if (coordList == null) {
            coordList = new ArrayList();
        }
        coordList.remove(coords);
        this.chestConfig.set(levelName, coordList);
    }

    @Override
    public void save() {
        this.chestConfig.save();
    }
}

