/*
 * Decompiled with CFR 0.152.
 */
package net.tee7even.presents.task;

import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.AngryVillagerParticle;
import cn.nukkit.level.particle.HappyVillagerParticle;
import cn.nukkit.level.particle.HeartParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.ShortTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.scheduler.Task;
import java.util.List;
import java.util.Random;
import net.tee7even.presents.Chest;
import net.tee7even.presents.Presents;

public class FirstStepTask
extends Task {
    private static Random rng = new Random();
    private Chest chest;
    private Block block;
    private Item item;

    public FirstStepTask(Chest chest, Block block, Item item) {
        this.chest = chest;
        this.block = block;
        this.item = item;
    }

    public void onRun(int currentTick) {
        HeartParticle particle;
        String name;
        List particles = Presents.getPlugin().getConfig().getStringList("particles");
        switch (name = (String)particles.get(rng.nextInt(particles.size()))) {
            case "hearts": {
                particle = new HeartParticle(new Vector3(0.0, 0.0, 0.0));
                break;
            }
            case "angry-villager": {
                particle = new AngryVillagerParticle(new Vector3(0.0, 0.0, 0.0));
                break;
            }
            default: {
                particle = new HappyVillagerParticle(new Vector3(0.0, 0.0, 0.0));
            }
        }
        for (int i = 0; i < 50; ++i) {
            particle.x = this.block.x + rng.nextDouble();
            particle.y = this.block.y + rng.nextDouble() + 0.9;
            particle.z = this.block.z + rng.nextDouble();
            this.block.getLevel().addParticle((Particle)particle);
        }
        Entity itemEntity = this.shootItem(this.block.getLevel(), new Vector3(this.block.x + 0.5, this.block.y + 0.5, this.block.z + 0.5), new Vector3(0.0, 0.3, 0.0));
        this.chest.setItemEntity(itemEntity);
    }

    private Entity shootItem(Level level, Vector3 source, Vector3 motion) {
        Entity itemEntity = Entity.createEntity((String)"Item", (FullChunk)level.getChunk((int)source.x >> 4, (int)source.z >> 4, false), (CompoundTag)new CompoundTag().put("Pos", (Tag)new ListTag("Pos").add((Tag)new DoubleTag("", source.x)).add((Tag)new DoubleTag("", source.y)).add((Tag)new DoubleTag("", source.z))).put("Motion", (Tag)new ListTag("Motion").add((Tag)new DoubleTag("", motion.x)).add((Tag)new DoubleTag("", motion.y)).add((Tag)new DoubleTag("", motion.z))).put("Rotation", (Tag)new ListTag("Rotation").add((Tag)new FloatTag("", 0.0f)).add((Tag)new FloatTag("", 0.0f))).put("Health", (Tag)new ShortTag("Health", 5)).put("Item", (Tag)new CompoundTag("Item").put("id", (Tag)new ShortTag("id", this.item.getId())).put("Count", (Tag)new ByteTag("Count", 1)).put("Damage", (Tag)new ShortTag("Damage", this.item.getDamage()))).put("PickupDelay", (Tag)new ShortTag("PickupDelay", 0)), (Object[])new Object[0]);
        itemEntity.spawnToAll();
        return itemEntity;
    }
}

