/*
 * Decompiled with CFR 0.152.
 */
package net.tee7even.presents;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.ConsoleCommandSender;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import net.tee7even.presents.ChestListener;
import net.tee7even.presents.ChestManager;
import net.tee7even.presents.utils.Message;
import net.tee7even.presents.utils.TextTagManager;

public class Presents
extends PluginBase {
    private static Presents plugin;

    public static Presents getPlugin() {
        return plugin;
    }

    public Presents() {
        plugin = this;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResource("messages.yml", false);
        this.saveResource("weights.yml", false);
        this.checkConfigVersion();
        Message.init();
        ChestManager.init();
        this.getServer().getPluginManager().registerEvents((Listener)new TextTagManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChestListener(), (Plugin)this);
    }

    public void onDisable() {
        ChestManager.close();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof ConsoleCommandSender) {
            return false;
        }
        if (command.getName().equals("placechest")) {
            ChestManager.place((Player)sender);
        }
        return true;
    }

    private void checkConfigVersion() {
        Config internalConfig = new Config();
        internalConfig.load(this.getResource("config.yml"));
        if (this.getConfig().getInt("version", -1) != internalConfig.getInt("version")) {
            this.getLogger().warning("Your config.yml is out of date. New features are added.\nBack it up, if needed, and delete. It will be replaced by a new one on start.");
        }
    }
}

