/*
 * Decompiled with CFR 0.152.
 */
package net.tee7even.presents.utils;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.level.Level;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import java.util.HashMap;

public class TextTagManager
implements Listener {
    private static int textTagCount = 0;
    private static HashMap<Integer, TextTag> textTags = new HashMap();

    public static int setTextTag(String text, Level level, double x, double y, double z) {
        TextTag textTag = new TextTag(text, level.getName(), x, y, z);
        AddEntityPacket packet = new AddEntityPacket();
        packet.type = 64;
        packet.entityRuntimeId = textTag.eid;
        packet.entityUniqueId = textTag.eid;
        packet.x = (float)textTag.x;
        packet.y = (float)textTag.y;
        packet.z = (float)textTag.z;
        packet.speedX = 0.0f;
        packet.speedY = 0.0f;
        packet.speedZ = 0.0f;
        long flags = 0L;
        flags |= 0x20L;
        flags |= 0x10000L;
        flags |= 0x4000L;
        packet.metadata = new EntityMetadata().putLong(0, flags |= 0x8000L).putString(4, text).putLong(38, -1L);
        level.addChunkPacket((int)textTag.x >> 4, (int)textTag.z >> 4, (DataPacket)packet);
        textTags.put(textTagCount, textTag);
        return textTagCount++;
    }

    public static void removeTextTag(int id) {
        if (!textTags.containsKey(id)) {
            return;
        }
        RemoveEntityPacket packet = new RemoveEntityPacket();
        packet.eid = TextTagManager.textTags.get((Object)Integer.valueOf((int)id)).eid;
        for (Player player : Server.getInstance().getOnlinePlayers().values()) {
            player.dataPacket((DataPacket)packet);
        }
        textTags.remove(id);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        AddEntityPacket packet = new AddEntityPacket();
        packet.type = 64;
        packet.speedX = 0.0f;
        packet.speedY = 0.0f;
        packet.speedZ = 0.0f;
        long flags = 0L;
        flags |= 0x20L;
        flags |= 0x10000L;
        flags |= 0x4000L;
        packet.metadata = new EntityMetadata().putLong(0, flags |= 0x8000L).putLong(38, -1L);
        for (TextTag textTag : textTags.values()) {
            if (!event.getPlayer().getLevel().getName().equals(textTag.levelName)) continue;
            packet.entityRuntimeId = textTag.eid;
            packet.entityUniqueId = textTag.eid;
            packet.x = (float)textTag.x;
            packet.y = (float)textTag.y;
            packet.z = (float)textTag.z;
            packet.metadata.putString(4, textTag.text);
            event.getPlayer().dataPacket((DataPacket)packet);
        }
    }

    private static class TextTag {
        String text;
        long eid;
        String levelName;
        double x;
        double y;
        double z;

        public TextTag(String text, String levelName, double x, double y, double z) {
            this.text = text;
            this.eid = Entity.entityCount++;
            this.levelName = levelName;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

