/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.scalloplog;

import cn.nukkit.block.Block;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.yescallop.scalloplog.ScallopLog;

public class EventListener
implements Listener {
    private ScallopLog plugin;

    public EventListener(ScallopLog plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Item item = event.getItem();
        Block block = event.getBlock();
        Item[] drops = event.getDrops();
        this.plugin.logPlayer(event.getPlayer(), "\u0434\u0405\u0457\u0437\u201d\u0401 " + item.getName() + " (" + item.getId() + ":" + item.getDamage() + ") \u0437\u00a0\u0491\u0435\u045c\u040f\u0434\u0454\u2020\u0434\u0405\u040c\u0434\u0454\u040b (" + block.level.getName() + ", " + (int)block.x + ", " + (int)block.y + ", " + (int)block.z + ") \u0437\u0459\u201e " + block.getName() + " (" + block.getId() + ":" + block.getDamage() + ")" + this.getItemsString(drops));
    }

    private String getItemsString(Item[] items) {
        if (items.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder("\u043f\u0458\u040a\u0436\u040b\u2030\u0438\u0452\u0405\u0437\u2030\u00a9\u0435\u201c\u0403\u043f\u0458\u0459");
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(item.getName() + " (" + item.getId() + ":" + item.getDamage() + ") * " + item.getCount());
        }
        return builder.toString();
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block blockReplace = event.getBlockReplace();
        Block block = event.getBlockAgainst();
        this.plugin.logPlayer(event.getPlayer(), "\u0435\u045a\u0401 (" + block.level.getName() + ", " + (int)block.x + ", " + (int)block.y + ", " + (int)block.z + ") \u0436\u201d\u0455\u0437\u0405\u00ae\u0434\u0454\u2020 " + block.getName() + " (" + block.getId() + ":" + block.getDamage() + ")" + (blockReplace.getId() == 0 ? "" : "\u043f\u0458\u040a\u0438\u00a6\u2020\u0437\u203a\u2013\u0434\u0454\u2020 " + blockReplace.getName() + " (" + blockReplace.getId() + ":" + blockReplace.getDamage() + ")"));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Block block = event.getBlockClicked().getSide(event.getBlockFace());
        Item bucket = event.getBucket();
        this.plugin.logPlayer(event.getPlayer(), "\u0435\u045a\u0401 (" + block.level.getName() + ", " + (int)block.x + ", " + (int)block.y + ", " + (int)block.z + ") \u0435\u0402\u2019\u0434\u0454\u2020\u0434\u0451\u0402\u0436\u040e\u00b6 " + bucket.getName() + " (" + bucket.getId() + ":" + bucket.getDamage() + ")");
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage();
        if (message.startsWith("/")) {
            this.plugin.logPlayer(event.getPlayer(), message);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == 1) {
            Block block = event.getBlock();
            Item item = event.getItem();
            this.plugin.logPlayer(event.getPlayer(), "\u0435\u0407\u2116\u0434\u0405\u040c\u0434\u0454\u040b (" + block.level.getName() + ", " + (int)block.x + ", " + (int)block.y + ", " + (int)block.z + ") \u0437\u0459\u201e " + block.getName() + " (" + block.getId() + ":" + block.getDamage() + ") \u0434\u0405\u0457\u0437\u201d\u0401\u0434\u0454\u2020 " + item.getName() + " (" + item.getId() + ":" + item.getDamage() + ")");
        }
    }
}

