/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.scalloplog;

import cn.nukkit.Player;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.yescallop.scalloplog.EventListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ScallopLog
extends PluginBase {
    private File log;

    public void onEnable() {
        this.log = new File(this.getServer().getDataPath() + "/scallop.log");
        if (!this.log.exists()) {
            try {
                this.log.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                this.setEnabled(false);
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
    }

    public void logRaw(String text) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.log, true), StandardCharsets.UTF_8);
            writer.write(format.format(new Date()) + " " + text + "\n");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.setEnabled(false);
        }
    }

    public void logPlayer(Player player, String text) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.logRaw("[" + player.getName() + "] " + text);
    }
}

