/*
 * Decompiled with CFR 0.152.
 */
package skygrid.generator;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;

public class SkygridGenerator
extends Generator {
    public static final int TYPE_SKYGRID = 3;
    public final int[] blocklist = new int[]{2, 12, 13, 14, 15, 16, 21, 24, 56, 73, 79, 80, 82, 86, 99, 100, 103, 110, 129, 159, 162};
    private ChunkManager level;
    private NukkitRandom random;
    private Map<String, Object> options;
    private Random rand = new Random(Calendar.getInstance().getTimeInMillis());

    public SkygridGenerator(Map<String, Object> map) {
        this.options = map;
    }

    public int getId() {
        return 3;
    }

    public void init(ChunkManager level, NukkitRandom random) {
        this.level = level;
        this.random = random;
    }

    public void generateChunk(int chunkX, int chunkZ) {
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        int x = 0;
        while (x < 16) {
            int z = 0;
            while (z < 16) {
                int y = 0;
                while (y < 128) {
                    int blockid = this.getRandomBlockId();
                    chunk.setBlock(x, y, z, Integer.valueOf(blockid), Integer.valueOf(blockid == 17 ? this.rand.nextInt(16) : 0));
                    y += 4;
                }
                z += 4;
            }
            x += 4;
        }
    }

    private int getRandomBlockId() {
        if (this.rand.nextInt(100) < 50) {
            int[] blockid = new int[]{1, 3, 17};
            return blockid[this.rand.nextInt(blockid.length)];
        }
        return this.blocklist[this.rand.nextInt(this.blocklist.length)];
    }

    public void populateChunk(int chunkX, int chunkZ) {
        this.random.setSeed((long)(0xDEADBEEF ^ chunkX << 8 ^ chunkZ) ^ this.level.getSeed());
    }

    public Map<String, Object> getSettings() {
        return this.options;
    }

    public String getName() {
        return "skygrid";
    }

    public Vector3 getSpawn() {
        return new Vector3(0.0, 80.0, 0.0);
    }

    public ChunkManager getChunkManager() {
        return this.level;
    }
}

