/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.smiley;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import java.io.File;
import java.io.IOException;
import ru.nukkit.smiley.Message;
import ru.nukkit.smiley.SmileyListener;
import ru.nukkit.smiley.Smileys;

public class Smiley
extends PluginBase {
    private static Smiley plugin;
    String default_color = "&f";
    boolean colorsmiles = true;
    boolean smileconsole = true;
    boolean smilecmd = true;
    boolean smilesign = true;
    boolean signcolor = false;
    boolean saveEncoded = true;

    public void onEnable() {
        plugin = this;
        this.initCfg();
        this.loadCfg();
        this.saveCfg();
        Smileys.init();
        Message.init(this);
        this.getServer().getPluginManager().registerEvents((Listener)new SmileyListener(), (Plugin)this);
    }

    private void initCfg() {
        this.getDataFolder().mkdirs();
        File f = new File(this.getDataFolder(), "config.yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void loadCfg() {
        Config cfg = this.getConfig();
        this.smileconsole = (Boolean)cfg.getNested("smiley.console", (Object)true);
        this.smilecmd = (Boolean)cfg.getNested("smiley.commands", (Object)true);
        this.colorsmiles = (Boolean)cfg.getNested("smiley.colors", (Object)true);
        this.smilesign = (Boolean)cfg.getNested("smiley.sign.enable-smileys", (Object)true);
        this.signcolor = (Boolean)cfg.getNested("smiley.sign.colored-smileys", (Object)false);
        this.default_color = (String)cfg.getNested("smiley.default-chat-color", (Object)"&f");
    }

    private void saveCfg() {
        Config cfg = this.getConfig();
        cfg.setNested("smiley.console", (Object)this.smileconsole);
        cfg.setNested("smiley.commands", (Object)this.smilecmd);
        cfg.setNested("smiley.colors", (Object)this.colorsmiles);
        cfg.setNested("smiley.sign.enable-smileys", (Object)this.smilesign);
        cfg.setNested("smiley.sign.colored-smileys", (Object)this.signcolor);
        cfg.setNested("smiley.default-chat-color", (Object)this.default_color);
        this.saveConfig();
    }

    public static Smiley getPlugin() {
        return plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd1, String cmdLabel, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args.length == 0) {
            return false;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("list")) {
            if (!sender.hasPermission("smiley.list") && player != null) {
                return false;
            }
            int pnum = 1;
            if (args.length == 2 && args[1].matches("\\d+")) {
                pnum = Integer.parseInt(args[1]);
            }
            Smileys.printSmileyList(sender, pnum);
        } else if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("smiley.config") && player != null) {
                return false;
            }
            this.loadCfg();
            Smileys.load();
            Message.RELOADED.print(sender, new Object[0]);
        } else {
            return false;
        }
        return true;
    }
}

