/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.smiley;

import cn.nukkit.command.CommandSender;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.TextFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import ru.nukkit.smiley.Message;
import ru.nukkit.smiley.Paginator;
import ru.nukkit.smiley.Smiley;

public class Smileys {
    private static Map<String, String> smiles = new HashMap<String, String>();

    public int getSmileIndex(String msg, String smilecode) {
        return msg.indexOf(smilecode);
    }

    private static String processSmile(String msg, String smilecode, String defcolor) {
        String str = msg;
        int i = str.indexOf(smilecode);
        if (i < 0) {
            return str;
        }
        String c = TextFormat.getLastColors((String)str.substring(0, i));
        if (c.isEmpty()) {
            c = defcolor;
        }
        try {
            str = str.replaceFirst(Pattern.quote(smilecode), TextFormat.colorize((String)(Smileys.get(smilecode) + c)));
        }
        catch (Exception e) {
            str = str.replaceFirst(Pattern.quote(smilecode), "");
            Message.debugMessage("Failed to parse smiley:", smilecode);
        }
        return str;
    }

    public static String processSmiles(String msg) {
        return Smileys.processSmiles(msg, Smiley.getPlugin().default_color);
    }

    public static String processSmiles(String msg, String defcolor) {
        String str = msg;
        for (String smilecode : smiles.keySet()) {
            while (str.contains(smilecode)) {
                str = Smileys.processSmile(str, smilecode, defcolor);
            }
        }
        return str;
    }

    public static String processSmilesDecolor(String txt) {
        String str = txt;
        for (String key : smiles.keySet()) {
            str = str.replace(key, TextFormat.clean((String)TextFormat.colorize((String)Smileys.get(key))));
        }
        return str;
    }

    public static void init() {
        smiles.clear();
        smiles.put(":(", "&c\u2639");
        smiles.put(":-(", "&c\u2639");
        smiles.put(":)", "&6\u263a");
        smiles.put(":D", "&6\u263b");
        smiles.put(":-)", "&6\u263b");
        smiles.put(";\\", "&6\u30c4");
        smiles.put(";)", "&6\u32e1");
        smiles.put("<3", "&4\u2661");
        smiles.put(":heart:", "&4\u2665");
        smiles.put(":peace:", "&e\u262e");
        smiles.put(":death:", "&4\u2620");
        smiles.put(":nuke:", "&6\u2622");
        smiles.put(":bio:", "&5\u2623");
        smiles.put(":cccp:", "&c\u262d");
        smiles.put(":ship:", "&3\u2638");
        smiles.put(":food:", "&a\u2668");
        smiles.put(":star:", "&e\u2600");
        smiles.put(":cloud:", "&b\u2601");
        smiles.put(":umbrella:", "&3\u2602");
        smiles.put(":snowman:", "&f\u2603");
        smiles.put(":sun:", "&6\u263c");
        smiles.put(":moonr:", "&a\u263d ");
        smiles.put(":moon:", "&a\u263e");
        smiles.put(":rmb:", "&6\u2756");
        smiles.put(":hat:", "&3\u3020");
        smiles.put(":8:", "&4\u267e");
        smiles.put(":star:", "&c\u2606");
        smiles.put(":darkstar:", "&4\u2605");
        smiles.put(":*:", "&4\u2605");
        smiles.put(":+:", "&c\u2606");
        smiles.put(":darkphone:", "&6\u260e");
        smiles.put(":phone:", "&4\u260f");
        smiles.put(":cup:", "&5\u2615");
        smiles.put(":yinyang:", "&1\u262f");
        smiles.put(":music:", "&5\u266b\u266a\u266c\u2669\u266a");
        smiles.put(":flag:", "&4\u2690");
        smiles.put(":redflag:", "&4\u2691");
        Smileys.load();
        Smileys.save();
    }

    public static String get(String key) {
        if (smiles.containsKey(key)) {
            return Smileys.parseUTF8(smiles.get(key));
        }
        return key;
    }

    public static void add(String key, String smile) {
        smiles.put(key, smile);
    }

    public static boolean remove(String key) {
        if (!smiles.containsKey(key)) {
            return false;
        }
        smiles.remove(key);
        return true;
    }

    public void clear() {
        smiles.clear();
    }

    public static void load() {
        try {
            Smiley.getPlugin().getDataFolder().mkdirs();
            File f = new File(Smiley.getPlugin().getDataFolder() + File.separator + "smiley.yml");
            if (!f.exists()) {
                return;
            }
            smiles.clear();
            Config cfg = new Config(f);
            for (String key : cfg.getAll().keySet()) {
                Smileys.add(key, (String)cfg.getNested(key, (Object)key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String stringToHex(String str) {
        if (str.isEmpty()) {
            return "";
        }
        String hstr = "";
        for (char c : str.toCharArray()) {
            hstr = hstr + (c < '\u0080' ? Character.toString(c) : "\\u" + Integer.toHexString(c));
        }
        return str;
    }

    public static void save() {
        try {
            Smiley.getPlugin().getDataFolder().mkdirs();
            File f = new File(Smiley.getPlugin().getDataFolder() + File.separator + "smiley.yml");
            if (!f.exists()) {
                f.delete();
            }
            f.createNewFile();
            if (smiles.isEmpty()) {
                return;
            }
            Config sml = new Config(f);
            for (String key : smiles.keySet()) {
                sml.setNested(key, (Object)(Smiley.getPlugin().saveEncoded ? Smileys.stringToHex(smiles.get(key)) : smiles.get(key)));
            }
            sml.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String parseUTF8(String instr) {
        char[] convtBuf;
        char[] in = instr.toCharArray();
        int len = in.length;
        int off = 0;
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static void printSmileyList(CommandSender sender, int page) {
        ArrayList<String> sm = new ArrayList<String>();
        for (String key : smiles.keySet()) {
            sm.add("&e" + key + " : " + smiles.get(key));
        }
        Paginator.printPage(sender, sm, Message.SMILEY_LIST.getText(Character.valueOf('6')), Message.SMILEY_LIST_FOOTER.getText(Character.valueOf('6')), Message.SMILEY_LIST_EMPTY.getText(Character.valueOf('c')), page, 0, false);
    }
}

