/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.smiley;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.level.Location;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.TextFormat;
import java.io.File;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Message {
    CMD_RELOAD("Configuration reloaded"),
    CMD_PERM_REQ("You have not enough permissions to execute this command"),
    LNG_LOAD_FAIL("Failed to load languages from file. Default message used"),
    LNG_SAVE_FAIL("Failed to save language file"),
    LNG_PRINT_FAIL("Failed to print message %1%. Sender object is null."),
    LNG_CONFIG("[MESSAGES] Messages: %1% Language: %2% Save translate file: %1% Debug mode: %3%"),
    WORD_UNKNOWN("Unknown"),
    SMILEY_LIST("Smiley list"),
    SMILEY_LIST_FOOTER("Page [%1% / [%2%]"),
    SMILEY_LIST_EMPTY("Smileys not found"),
    RELOADED("Configuration reloaded!");

    private static PluginBase plugin;
    private static boolean debugMode;
    private static String language;
    private static boolean languageSave;
    private static char c1;
    private static char c2;
    private String message;

    public static void BC(Object ... s) {
        if (!debugMode) {
            return;
        }
        if (s.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder("&3[").append(plugin.getDescription().getName()).append("]&f ");
        for (Object str : s) {
            sb.append(str.toString()).append(" ");
        }
        plugin.getServer().broadcastMessage(TextFormat.colorize((String)sb.toString().trim()));
    }

    public boolean log(Object ... s) {
        plugin.getLogger().info(this.getText(s));
        return true;
    }

    public boolean debug(Object ... s) {
        if (debugMode) {
            plugin.getLogger().info(TextFormat.clean((String)this.getText(s)));
        }
        return true;
    }

    public boolean print(CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        sender.sendMessage(this.getText(s));
        return true;
    }

    public boolean broadcast(String permission, Object ... s) {
        for (Player player : plugin.getServer().getOnlinePlayers().values()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            this.print((CommandSender)player, s);
        }
        return true;
    }

    public String getText(Object ... keys) {
        if (keys.length == 0) {
            return TextFormat.colorize((String)("&" + c1 + this.message));
        }
        String str = this.message;
        boolean noColors = false;
        boolean skipDefaultColors = false;
        boolean fullFloat = false;
        int count = 1;
        char[] colors = new char[]{c1, c2};
        int c = 0;
        DecimalFormat fmt = new DecimalFormat("####0.##");
        for (int i = 0; i < keys.length; ++i) {
            String s = keys[i].toString();
            if (c < 2 && keys[i] instanceof Character) {
                colors[c] = ((Character)keys[i]).charValue();
                ++c;
                continue;
            }
            if (s.equals("SKIPCOLOR")) {
                skipDefaultColors = true;
                continue;
            }
            if (s.equals("NOCOLORS") || s.equals("NOCOLOR")) {
                noColors = true;
                continue;
            }
            if (s.equals("FULLFLOAT")) {
                fullFloat = true;
                continue;
            }
            if (keys[i] instanceof Location) {
                Location loc = (Location)keys[i];
                s = fullFloat ? loc.getLevel().getName() + "[" + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + "]" : loc.getLevel().getName() + "[" + fmt.format(loc.getX()) + ", " + fmt.format(loc.getY()) + ", " + fmt.format(loc.getZ()) + "]";
            } else if ((keys[i] instanceof Double || keys[i] instanceof Float) && !fullFloat) {
                s = fmt.format((Double)keys[i]);
            }
            String from = "%" + count + "%";
            String to = skipDefaultColors ? s : "&" + colors[1] + s + "&" + colors[0];
            str = str.replace(from, to);
            ++count;
        }
        str = TextFormat.colorize((String)("&" + colors[0] + str));
        if (noColors) {
            str = TextFormat.clean((String)str);
        }
        return str;
    }

    public void initMessage(String message) {
        this.message = message;
    }

    private Message(String msg) {
        this.message = msg;
    }

    public static void init(PluginBase plg) {
        plugin = plg;
        language = (String)plg.getConfig().getNested("general.language", (Object)"english");
        plg.getConfig().setNested("general.language", (Object)language);
        languageSave = (Boolean)plg.getConfig().getNested("general.language-save", (Object)true);
        plg.getConfig().setNested("general.language-save", (Object)languageSave);
        debugMode = (Boolean)plg.getConfig().getNested("general.debug-mode", (Object)false);
        plg.getConfig().setNested("general.debug-mode", (Object)debugMode);
        plg.saveConfig();
        Message.initMessages();
        if (languageSave) {
            Message.saveMessages();
        }
        LNG_CONFIG.debug(Message.values().length, language, languageSave, debugMode);
    }

    public static void setDebugMode(boolean debug) {
        debugMode = debug;
    }

    private static boolean copyLanguage() {
        return plugin.saveResource("lang/" + language + ".lng", language + ".lng", false);
    }

    private static void initMessages() {
        Message.copyLanguage();
        Config lng = null;
        try {
            File f = new File(plugin.getDataFolder() + File.separator + language + ".lng");
            lng = new Config(f, 2);
        }
        catch (Exception e) {
            LNG_LOAD_FAIL.log(new Object[0]);
            if (debugMode) {
                e.printStackTrace();
            }
            return;
        }
        for (Message key : Message.values()) {
            key.initMessage((String)lng.get(key.name().toLowerCase(), (Object)key.message));
        }
    }

    private static void saveMessages() {
        File f = new File(plugin.getDataFolder() + File.separator + language + ".lng");
        Config lng = new Config(f, 2);
        for (Message key : Message.values()) {
            lng.set(key.name().toLowerCase(), (Object)key.message);
        }
        try {
            lng.save();
        }
        catch (Exception e) {
            LNG_SAVE_FAIL.log(new Object[0]);
            if (debugMode) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static boolean debugMessage(Object ... s) {
        if (debugMode) {
            plugin.getLogger().info(TextFormat.clean((String)Message.join(s)));
        }
        return true;
    }

    public static String join(Object ... s) {
        StringBuilder sb = new StringBuilder();
        for (Object o : s) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    static {
        plugin = null;
        debugMode = false;
        language = "english";
        languageSave = false;
        c1 = (char)97;
        c2 = (char)50;
    }
}

