/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.smiley;

import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.SignChangeEvent;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.server.ServerCommandEvent;
import ru.nukkit.smiley.Smiley;
import ru.nukkit.smiley.Smileys;

public class SmileyListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSmileChat(PlayerChatEvent event) {
        if (!event.getPlayer().hasPermission("smiley.chat")) {
            return;
        }
        if (Smiley.getPlugin().colorsmiles) {
            event.setMessage(Smileys.processSmiles(event.getMessage()));
        } else {
            event.setMessage(Smileys.processSmilesDecolor(event.getMessage()));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSmileCmd(PlayerCommandPreprocessEvent event) {
        if (!Smiley.getPlugin().smilecmd) {
            return;
        }
        if (!event.getPlayer().hasPermission("smiley.commands")) {
            return;
        }
        if (Smiley.getPlugin().colorsmiles) {
            event.setMessage(Smileys.processSmiles(event.getMessage()));
        } else {
            event.setMessage(Smileys.processSmilesDecolor(event.getMessage()));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onRecodeConsoleCmd(ServerCommandEvent event) {
        if (!Smiley.getPlugin().smileconsole) {
            return;
        }
        if (Smiley.getPlugin().colorsmiles) {
            event.setCommand(Smileys.processSmiles(event.getCommand()));
        } else {
            event.setCommand(Smileys.processSmilesDecolor(event.getCommand()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSignSmiley(SignChangeEvent event) {
        if (!event.getPlayer().hasPermission("smiley.sign")) {
            return;
        }
        if (!Smiley.getPlugin().smilesign) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (event.getLine(i).isEmpty()) continue;
            if (Smiley.getPlugin().signcolor) {
                event.setLine(i, Smileys.processSmiles(event.getLine(i), "&0"));
                continue;
            }
            event.setLine(i, Smileys.processSmilesDecolor(event.getLine(i)));
        }
    }
}

