package ToolsPro.commands;

import ToolsPro.ToolsPro;
import ToolsPro.util.Message;
import cn.nukkit.Player;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.Block;
import cn.nukkit.command.CommandSender;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Pub4Game on 12.02.2015.
 */
public class TPAllCommand extends Commands {

    private ToolsPro plugin;

    public TPAllCommand(ToolsPro plugin) {
        super("tpall", Message.CMD_BREAK_DESCRIPTION, "/tpall");
        this.setPermission("toolspro.commands.tpall");
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            Message.YOU_DONT_HAVE_PERMISSION.print(sender, 'c');
        } else {
            if (args.length != 0) {
                Player player = this.plugin.getServer().getPlayer(args[0]);
                for (Player p : this.plugin.getServer().getOnlinePlayers().values()) {
                    if (p != player) {
                        p.teleport(player);
                        p.sendMessage("Teleporting to " + player.getDisplayName() + "...");
                    }
                }
                sender.sendMessage("Вы телепортировали всех игроков на сервере к игроку: " + player.getName());
                player.sendMessage("К Вам были телепортированы все игроки на сервере...");
            } else {
                if (sender instanceof Player) {
                    for (Player p : this.plugin.getServer().getOnlinePlayers().values()) {
                        if (p != sender) {
                            p.teleport((Player) sender);
                            p.sendMessage("Teleporting to " + ((Player) sender).getDisplayName() + "...");
                        }
                    }
                    sender.sendMessage("Teleporting players to you...");
                } else {
                    return Message.NEED_PLAYER.print(sender, "prefix:&7[&aTeleport&7]", 'c');
                }
            }
        }
        return true;
    }
}
