package ToolsPro.commands;

import ToolsPro.ToolsPro;
import ToolsPro.util.Message;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.utils.Config;

import java.io.File;

/**
 * Created by Pub4Game on 07.02.2015.
 */
public class WhoIsCommand extends Commands {

    private ToolsPro plugin;

    public WhoIsCommand(ToolsPro plugin) {
        super("whois", Message.CMD_REALNAME_DESCRIPTION, Message.CMD_REALNAME_DESCRIPTION2.toString());
        this.setPermission("toolspro.commands.whois");
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            Message.YOU_DONT_HAVE_PERMISSION.print(sender, 'c');
        } else {
            if (args.length > 0) {
                Player p = this.plugin.getServer().getPlayer(args[0]);
                if (p != null) {
                    Config mute = new Config(new File(this.plugin.getDataFolder(), "mute.yml"), Config.YAML);
                    sender.sendMessage("Информация о игроке " + p.getName());
                    sender.sendMessage("Имя игрока: " + p.getName());
                    sender.sendMessage("Кол-во жизней: §a" + p.getHealth() + "§b/§c" + p.getMaxHealth());
                    sender.sendMessage("Игровой режим ирока: " + this.plugin.getServer().getGamemodeString(p.getGamemode()));
                    //sender.sendMessage("Muted: " + (mute.exists(p.getName().toLowerCase()) ? Message.CMD_WHOIS_MUTE_YES.getText('c') : Message.CMD_WHOIS_MUTE_NO.getText('a')));
                    sender.sendMessage("Fly: " + ((p.getAllowFlight() && p.getGamemode() != 1 && p.getGamemode() != 3) ? Message.CMD_WHOIS_ENABLED.getText('a') : Message.CMD_WHOIS_DISABLED.getText('c')));
                    sender.sendMessage("SaveInv: " + (this.plugin.getPlayerSaveInv(p) ? Message.CMD_WHOIS_ENABLED.getText('a') : Message.CMD_WHOIS_DISABLED.getText('c')));
                    sender.sendMessage("God: " + (this.plugin.getPlayerGodMode(p) ? Message.CMD_WHOIS_ENABLED.getText('a') : Message.CMD_WHOIS_DISABLED.getText('c')));
                    sender.sendMessage("Vanish: " + (this.plugin.getPlayerVanish(p) ? Message.CMD_WHOIS_ENABLED.getText('a') : Message.CMD_WHOIS_DISABLED.getText('c')));
                } else {
                    Message.UNKNOWN_PLAYER.print(sender, "prefix:&7[&aWhoIs&7]", 'c');
                }
            } else {
                //USAGE
            }
        }
        return true;
    }
}
