package ToolsPro.commands;

import ToolsPro.ToolsPro;
import ToolsPro.util.Message;
import cn.nukkit.Player;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.Block;
import cn.nukkit.command.CommandSender;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Pub4Game on 12.02.2015.
 */
public class TPHereCommand extends Commands {

    private ToolsPro plugin;

    public TPHereCommand(ToolsPro plugin) {
        super("tphere", Message.CMD_BREAK_DESCRIPTION, "/tphere");
        this.setPermission("toolspro.commands.tphere");
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            Message.YOU_DONT_HAVE_PERMISSION.print(sender, 'c');
        } else {
            if (args.length != 0) {
                Player p = this.plugin.getServer().getPlayer(args[0]);
                if (p != null) {
                    p.teleport((Player) sender);
                    p.sendMessage("Teleporting to " + ((Player) sender).getDisplayName() + "...");
                    sender.sendMessage("Teleporting " + p.getDisplayName() + " to you...");
                } else {
                    Message.UNKNOWN_PLAYER.print(sender, "prefix:&7[&aTeleport&7]", 'c');
                }
            } else {
                //USAGE
            }
        }
        return true;
    }
}
