/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.touchtodo;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.math.Vector2;
import cn.yescallop.touchtodo.TouchToDo;
import cn.yescallop.touchtodo.lang.BaseLang;

public class EventListener
implements Listener {
    TouchToDo plugin;
    BaseLang lang;

    public EventListener(TouchToDo plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguage();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        String command;
        if (event.getAction() != 1) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        int distance = Server.getInstance().getSpawnRadius();
        if (!player.isOp() && distance > -1) {
            Vector2 t = new Vector2(block.x, block.z);
            Vector2 s = new Vector2(block.level.getSpawnLocation().x, block.level.getSpawnLocation().z);
            if (Server.getInstance().getOps().getAll().isEmpty() && !(t.distance(s) <= (double)distance)) {
                return;
            }
        }
        if (this.plugin.isWaiting(player)) {
            event.setCancelled();
            if (this.plugin.isRemoveWaiting(player)) {
                if (this.plugin.removeBlockCommand(block)) {
                    player.sendMessage(this.lang.translateString("commands.touchtodo.remove.success"));
                } else {
                    player.sendMessage(this.lang.translateString("commands.touchtodo.remove.fail"));
                }
            } else {
                command = this.plugin.getSetWaiting(player);
                if (command == null) {
                    command = this.plugin.getOpSetWaiting(player);
                    this.plugin.setBlockCommand(block, command, true);
                } else {
                    this.plugin.setBlockCommand(block, command, false);
                }
                player.sendMessage(this.lang.translateString("commands.touchtodo.set.success", "/" + command));
            }
            this.plugin.removeWaiting(player);
        } else {
            command = this.plugin.getBlockCommand(block);
            if (command != null) {
                event.setCancelled();
                if (this.plugin.isBlockCommandOp(block) && !player.isOp()) {
                    player.setOp(true);
                    Server.getInstance().dispatchCommand((CommandSender)player, command);
                    player.setOp(false);
                } else {
                    Server.getInstance().dispatchCommand((CommandSender)player, command);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (player == null || this.plugin.getBlockCommand(block) == null) {
            return;
        }
        if (!player.hasPermission("touchtodo.break.commandblock")) {
            event.setCancelled();
            player.sendMessage("\u00a7c" + this.lang.translateString("touchtodo.break.nopermission"));
        } else if (!event.isCancelled()) {
            this.plugin.removeBlockCommand(block);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.removeWaiting(event.getPlayer());
    }
}

