/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.touchtodo;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.event.Listener;
import cn.nukkit.level.Level;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.yescallop.touchtodo.EventListener;
import cn.yescallop.touchtodo.command.CommandManager;
import cn.yescallop.touchtodo.lang.BaseLang;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TouchToDo
extends PluginBase {
    private File worldsFolder;
    private HashMap<String, String> setWaiting = new HashMap();
    private HashMap<String, String> opSetWaiting = new HashMap();
    private ArrayList<String> removeWaiting = new ArrayList();
    private BaseLang lang;

    public void onEnable() {
        this.getDataFolder().mkdirs();
        this.worldsFolder = new File(this.getDataFolder(), "worlds");
        this.worldsFolder.mkdirs();
        this.lang = new BaseLang(this.getServer().getLanguage().getLang());
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
        CommandManager.registerAll(this);
        this.getLogger().info(this.lang.translateString("touchtodo.loaded"));
    }

    public BaseLang getLanguage() {
        return this.lang;
    }

    public void addSetWaiting(Player player, String command) {
        this.setWaiting.put(player.getName().toLowerCase(), command);
    }

    public void addOpSetWaiting(Player player, String command) {
        this.opSetWaiting.put(player.getName().toLowerCase(), command);
    }

    public void addRemoveWaiting(Player player) {
        this.removeWaiting.add(player.getName().toLowerCase());
    }

    public boolean removeWaiting(Player player) {
        return this.setWaiting.remove(player.getName().toLowerCase()) != null || this.opSetWaiting.remove(player.getName().toLowerCase()) != null || this.removeWaiting.remove(player.getName().toLowerCase());
    }

    public boolean isWaiting(Player player) {
        return this.getSetWaiting(player) != null || this.getOpSetWaiting(player) != null || this.isRemoveWaiting(player);
    }

    public String getSetWaiting(Player player) {
        return this.setWaiting.get(player.getName().toLowerCase());
    }

    public String getOpSetWaiting(Player player) {
        return this.opSetWaiting.get(player.getName().toLowerCase());
    }

    public boolean isRemoveWaiting(Player player) {
        return this.removeWaiting.contains(player.getName().toLowerCase());
    }

    public void setBlockCommand(Block block, String command, boolean op) {
        Config config = this.getLevelConfig(block.level);
        config.set(this.implode(this.getVector3FlooredArray((Vector3)block), ","), (Object)new Object[]{command, op});
        config.save();
    }

    public String getBlockCommand(Block block) {
        Config config = this.getLevelConfig(block.level);
        ArrayList command = (ArrayList)config.get(this.implode(this.getVector3FlooredArray((Vector3)block), ","));
        return command == null ? null : (String)command.get(0);
    }

    public boolean isBlockCommandOp(Block block) {
        Config config = this.getLevelConfig(block.level);
        ArrayList command = (ArrayList)config.get(this.implode(this.getVector3FlooredArray((Vector3)block), ","));
        return command == null ? false : (Boolean)command.get(1);
    }

    public boolean removeBlockCommand(Block block) {
        Config config = this.getLevelConfig(block.level);
        String key = this.implode(this.getVector3FlooredArray((Vector3)block), ",");
        boolean exists = config.exists(key);
        config.remove(key);
        config.save();
        return exists;
    }

    private String[] getVector3FlooredArray(Vector3 pos) {
        return new String[]{String.valueOf((int)pos.x), String.valueOf((int)pos.y), String.valueOf((int)pos.z)};
    }

    public String implode(String[] arr, String sp) {
        String output = "";
        for (int i = 0; i < arr.length; ++i) {
            output = output + arr[i];
            if (arr.length - i == 1) continue;
            output = output + sp;
        }
        return output;
    }

    public Config getLevelConfig(Level level) {
        return new Config(new File(this.worldsFolder, level.getName() + ".yml"), 2);
    }

    public File getLevelFolder(Level level) {
        File folder = new File(this.worldsFolder, level.getName());
        folder.mkdirs();
        return folder;
    }
}

