/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.touchtodo.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.TextContainer;
import cn.nukkit.event.TranslationContainer;
import cn.yescallop.touchtodo.TouchToDo;
import cn.yescallop.touchtodo.command.CommandBase;
import java.util.ArrayList;
import java.util.Arrays;

public class TouchToDoCommand
extends CommandBase {
    public TouchToDoCommand(TouchToDo plugin) {
        super("touchtodo", plugin);
        this.setAliases(new String[]{"ttd", "t"});
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c" + this.lang.translateString("commands.generic.onlyPlayer"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            sender.sendMessage((TextContainer)new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        switch (args[0]) {
            case "set": {
                if (this.plugin.isWaiting(player)) {
                    this.plugin.removeWaiting(player);
                }
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
                list.remove(0);
                String command = this.plugin.implode(list.toArray(new String[0]), " ");
                if (list.size() == 0) {
                    sender.sendMessage((TextContainer)new TranslationContainer("commands.generic.usage", this.usageMessage));
                    return false;
                }
                if (!command.startsWith("/")) {
                    sender.sendMessage(this.lang.translateString("commands.touchtodo.set.invalidprefix"));
                    return false;
                }
                this.plugin.addSetWaiting(player, command.substring(1));
                sender.sendMessage(this.lang.translateString("commands.touchtodo.set.waiting", command));
                break;
            }
            case "opset": {
                if (this.plugin.isWaiting(player)) {
                    this.plugin.removeWaiting(player);
                }
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
                list.remove(0);
                String command = this.plugin.implode(list.toArray(new String[0]), " ");
                if (list.size() == 0) {
                    sender.sendMessage((TextContainer)new TranslationContainer("commands.generic.usage", this.usageMessage));
                    return false;
                }
                if (!command.startsWith("/")) {
                    sender.sendMessage(this.lang.translateString("commands.touchtodo.set.invalidprefix"));
                    return false;
                }
                this.plugin.addOpSetWaiting(player, command.substring(1));
                sender.sendMessage(this.lang.translateString("commands.touchtodo.set.waiting", command));
                break;
            }
            case "remove": {
                if (this.plugin.isWaiting(player)) {
                    this.plugin.removeWaiting(player);
                }
                this.plugin.addRemoveWaiting(player);
                sender.sendMessage(this.lang.translateString("commands.touchtodo.remove.waiting"));
                break;
            }
            case "abort": {
                if (this.plugin.removeWaiting(player)) {
                    sender.sendMessage(this.lang.translateString("commands.touchtodo.abort.success"));
                    break;
                }
                sender.sendMessage(this.lang.translateString("commands.touchtodo.abort.fail"));
                break;
            }
            default: {
                sender.sendMessage((TextContainer)new TranslationContainer("commands.generic.usage", this.usageMessage));
            }
        }
        return false;
    }
}

