/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.players;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.entity.Effect;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.plugin.Plugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import ru.nukkit.welcome.Welcome;
import ru.nukkit.welcome.password.PasswordProvider;
import ru.nukkit.welcome.password.PasswordValidator;
import ru.nukkit.welcome.util.LoginMeta;
import ru.nukkit.welcome.util.Message;

public class PlayerManager {
    private static Map<String, Long> waitLogin = new HashMap<String, Long>();

    public UUID getID(Player player) {
        return null;
    }

    public static void enterServer(Player player) {
        String playerName = player.getName();
        if (waitLogin.containsKey(playerName)) {
            waitLogin.remove(playerName);
        }
        if (player.hasMetadata("welcome-in-game")) {
            player.removeMetadata("welcome-in-game", (Plugin)Welcome.getPlugin());
        }
        if (PasswordProvider.checkAutologin(player)) {
            PlayerManager.setPlayerLoggedIn(player);
            Message.LGN_AUTO.tip(5, (CommandSender)player, Character.valueOf('e'), Character.valueOf('6'), player.getName());
            return;
        }
        PlayerManager.setBlindEffect(player);
        if (!PasswordProvider.hasPassword(player)) {
            PlayerManager.startWaitRegister(player);
        } else {
            PlayerManager.startWaitLogin(player);
        }
    }

    public static boolean isPlayerLoggedIn(Player player) {
        return player.hasMetadata("welcome-in-game");
    }

    public static void setPlayerLoggedIn(Player player) {
        player.setMetadata("welcome-in-game", (MetadataValue)new LoginMeta());
    }

    public static void setPlayerLoggedOff(Player player) {
        if (player.hasMetadata("welcome-in-game")) {
            player.removeMetadata("welcome-in-game", (Plugin)Welcome.getPlugin());
        }
    }

    private static void startWaitRegister(final Player player) {
        if (!player.isOnline()) {
            return;
        }
        if (PlayerManager.isPlayerRegistered(player)) {
            return;
        }
        String name = player.getName();
        if (!waitLogin.containsKey(name)) {
            waitLogin.put(name, System.currentTimeMillis() + Welcome.getPlugin().getWaitTime());
        }
        if (System.currentTimeMillis() < waitLogin.get(name)) {
            Message.TYPE_REG.tip(5, (CommandSender)player, new Object[0]);
            Welcome.getPlugin().getServer().getScheduler().scheduleDelayedTask(new Runnable(){

                public void run() {
                    PlayerManager.startWaitRegister(player);
                }
            }, 200);
        } else {
            player.kick(Message.KICK_TIMEOUT.getText(new Object[0]), false);
        }
    }

    private static boolean isPlayerRegistered(Player player) {
        return PasswordProvider.hasPassword(player);
    }

    private static void startWaitLogin(final Player player) {
        if (!player.isOnline()) {
            return;
        }
        if (PlayerManager.isPlayerLoggedIn(player)) {
            return;
        }
        String name = player.getName();
        if (!waitLogin.containsKey(name)) {
            waitLogin.put(name, System.currentTimeMillis() + Welcome.getPlugin().getWaitTime());
        }
        if (System.currentTimeMillis() < waitLogin.get(name)) {
            Message.TYPE_LGN.tip(5, (CommandSender)player, new Object[0]);
            Server.getInstance().getScheduler().scheduleDelayedTask(new Runnable(){

                public void run() {
                    PlayerManager.startWaitLogin(player);
                }
            }, 200);
        } else {
            player.kick(Message.KICK_TIMEOUT.getText(new Object[0]), false);
        }
    }

    public static boolean regCommand(Player player, String password1, String password2) {
        if (PlayerManager.isPlayerRegistered(player)) {
            return Message.REG_ALREADY.print((CommandSender)player, new Object[0]);
        }
        if (PlayerManager.isPlayerLoggedIn(player)) {
            return Message.LGN_ALREADY.print((CommandSender)player, new Object[0]);
        }
        if (password1 == null || password1.isEmpty() || password2 == null || password2.isEmpty()) {
            return Message.TYPE_REG.print((CommandSender)player, Character.valueOf('c'));
        }
        if (!password1.equals(password2)) {
            return Message.ERR_PWD_NOTMATCH.print((CommandSender)player, Character.valueOf('c'));
        }
        if (!PasswordValidator.validatePassword(password1)) {
            Message.ERR_PWD_VALIDATE.print((CommandSender)player, Character.valueOf('c'));
            player.sendMessage(PasswordValidator.getInfo());
            return true;
        }
        PasswordProvider.setPassword(player, password1);
        PlayerManager.setPlayerLoggedIn(player);
        Message.REG_LOG.log(player.getName(), "NOCOLOR");
        Message.REG_OK.print((CommandSender)player, Character.valueOf('6'));
        PasswordProvider.updateAutologin(player);
        PlayerManager.clearBlindEffect(player);
        return Message.REG_OK.tip(5, (CommandSender)player, Character.valueOf('6'));
    }

    public static boolean loginCommand(Player player, String password) {
        if (password == null || password.isEmpty()) {
            return Message.LGN_MISS_PWD.print((CommandSender)player, new Object[0]);
        }
        if (PlayerManager.isPlayerLoggedIn(player)) {
            return Message.LGN_ALREADY.print((CommandSender)player, new Object[0]);
        }
        if (!PasswordProvider.checkPassword(player, password)) {
            return Message.ERR_PWD_WRONG.print((CommandSender)player, new Object[0]);
        }
        PlayerManager.setPlayerLoggedIn(player);
        Message.LGN_LOG.log(player.getName(), "NOCOLOR");
        Message.LGN_OK.print((CommandSender)player, Character.valueOf('6'));
        PasswordProvider.updateAutologin(player);
        PlayerManager.clearBlindEffect(player);
        return Message.LGN_OK.tip(5, (CommandSender)player, Character.valueOf('6'));
    }

    public static boolean logOff(Player player) {
        if (!PlayerManager.isPlayerLoggedIn(player)) {
            return Message.ERR_NOT_LOGGED.print((CommandSender)player, new Object[0]);
        }
        PlayerManager.setPlayerLoggedOff(player);
        PasswordProvider.removeAutologin(player);
        return player.kick(Message.LOGOFF_OK.getText(new Object[0]), false);
    }

    public static boolean unregCommand(Player player, String password) {
        if (password == null || password.isEmpty()) {
            return Message.UNREG_MISS_PWD.print((CommandSender)player, new Object[0]);
        }
        if (!PasswordProvider.checkPassword(player, password)) {
            return Message.ERR_PWD_WRONG.print((CommandSender)player, new Object[0]);
        }
        PasswordProvider.removePassword(player);
        return player.kick(Message.UNREG_OK.getText(new Object[0]), false);
    }

    private static void clearBlindEffect(Player player) {
        if (!Welcome.getPlugin().useBlindEffect()) {
            return;
        }
        if (player.hasEffect(15)) {
            player.removeEffect(15);
        }
    }

    private static void setBlindEffect(Player player) {
        if (!Welcome.getPlugin().useBlindEffect()) {
            return;
        }
        Effect effect = Effect.getEffect((int)15);
        effect.setAmbient(false);
        effect.setDuration(Integer.MAX_VALUE);
        effect.setAmplifier(10);
        player.addEffect(effect);
    }
}

