/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome;

import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import ru.nukkit.welcome.WelcomeListener;
import ru.nukkit.welcome.commands.Commander;
import ru.nukkit.welcome.password.HashType;
import ru.nukkit.welcome.password.PasswordProvider;
import ru.nukkit.welcome.password.PasswordValidator;
import ru.nukkit.welcome.players.ForbidActions;
import ru.nukkit.welcome.util.Message;
import ru.nukkit.welcome.util.TimeUtil;

public class Welcome
extends PluginBase {
    private static Welcome instance;
    private String passwordProvider;
    String timeWaitLogin;
    String hashMethod;
    boolean autologinDisabled;
    String autoLoginMaxTime;
    boolean validatorSpecialChar;
    boolean validatorCapitalLetter;
    boolean validatorNumber;
    int validatorMinLength;
    int validatorMaxLength;
    boolean setBlindEffect;

    public static Welcome getPlugin() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.loadCfg();
        Message.init(this);
        PasswordValidator.init(this.validatorSpecialChar, this.validatorCapitalLetter, this.validatorNumber, this.validatorMinLength, this.validatorMaxLength);
        PasswordProvider.init();
        this.getServer().getPluginManager().registerEvents((Listener)new WelcomeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ForbidActions(), (Plugin)this);
        Commander.init(this);
    }

    public void loadCfg() {
        this.getDataFolder().mkdirs();
        this.saveResource("config.yml");
        this.reloadConfig();
        this.hashMethod = (String)this.getConfig().getNested("password.hash-algorithm", (Object)HashType.SHA256.name());
        this.timeWaitLogin = (String)this.getConfig().getNested("password.wait-time", (Object)"3m");
        this.passwordProvider = (String)this.getConfig().getNested("database.provider", (Object)PasswordProvider.DATABASE.name());
        this.autologinDisabled = (Boolean)this.getConfig().getNested("autologin.disable", (Object)false);
        this.autoLoginMaxTime = (String)this.getConfig().getNested("autologin.time", (Object)"15m");
        this.validatorCapitalLetter = (Boolean)this.getConfig().getNested("validate-force-capitals", (Object)false);
        this.validatorSpecialChar = (Boolean)this.getConfig().getNested("password.validator.force-specials", (Object)false);
        this.validatorNumber = (Boolean)this.getConfig().getNested("password.validator.force-numbers", (Object)true);
        this.validatorMinLength = (Integer)this.getConfig().getNested("password.validator.min-length", (Object)6);
        this.validatorMaxLength = (Integer)this.getConfig().getNested("password.validator.max-length", (Object)16);
        this.setBlindEffect = (Boolean)this.getConfig().getNested("before-login.blind-effect", (Object)true);
    }

    public HashType getHashAlgorithm() {
        return HashType.getAlgorithm(this.hashMethod);
    }

    public String getPasswordProvider() {
        return this.passwordProvider;
    }

    public boolean isAutologinDisabled() {
        return this.autologinDisabled;
    }

    public long getMaxAutoTime() {
        return TimeUtil.parseTime(this.autoLoginMaxTime);
    }

    public Long getWaitTime() {
        return TimeUtil.parseTime(this.timeWaitLogin);
    }

    public boolean useBlindEffect() {
        return this.setBlindEffect;
    }
}

