/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.password;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HashType {
    PLAIN("PLAIN"),
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA512("SHA-512");

    private String algStr;

    private HashType(String algStr) {
        this.algStr = algStr;
    }

    public String getHash(String str) {
        if (this == PLAIN) {
            return str;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(this.algStr);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] byteData = new byte[]{};
        try {
            byteData = digest.digest(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String getHash(String password, HashType algorithmType) {
        return algorithmType.getHash(password);
    }

    public static HashType getAlgorithm(String id) {
        for (HashType at : HashType.values()) {
            if (!at.name().equalsIgnoreCase(id) && !at.algStr.equalsIgnoreCase(id)) continue;
            return at;
        }
        return PLAIN;
    }
}

