/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.password;

import cn.nukkit.Player;
import ru.nukkit.welcome.Welcome;
import ru.nukkit.welcome.password.Password;
import ru.nukkit.welcome.password.PasswordDbLib;
import ru.nukkit.welcome.password.PasswordYaml;
import ru.nukkit.welcome.players.PlayerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PasswordProvider {
    YAML(PasswordYaml.class),
    DATABASE(PasswordDbLib.class);

    Class<? extends Password> clazz;
    private static Password passworder;

    private PasswordProvider(Class<? extends Password> clazz) {
        this.clazz = clazz;
    }

    public Password getProvider() {
        try {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void init() {
        PasswordProvider pp = PasswordProvider.getByName(Welcome.getPlugin().getPasswordProvider());
        if (pp == null) {
            pp = YAML;
            Welcome.getPlugin().getLogger().info("Failed to determine password provider: " + Welcome.getPlugin().getPasswordProvider() + " YAML will be used...");
        }
        if (!(passworder = pp.getProvider()).isEnabled()) {
            Welcome.getPlugin().getLogger().info("Failed to initialize: " + Welcome.getPlugin().getPasswordProvider() + " YAML will be used...");
            pp = YAML;
            passworder = YAML.getProvider();
        }
        Welcome.getPlugin().getLogger().info("\u00a7aPassword provider: " + pp.name() + " Hash algorithm: " + Welcome.getPlugin().getHashAlgorithm().name());
    }

    public static PasswordProvider getByName(String pwdProv) {
        for (PasswordProvider pp : PasswordProvider.values()) {
            if (!pp.name().equalsIgnoreCase(pwdProv)) continue;
            return pp;
        }
        return null;
    }

    public static boolean checkPassword(String playerName, String pwdStr) {
        return passworder.checkPassword(playerName, Welcome.getPlugin().getHashAlgorithm().getHash(pwdStr));
    }

    public static boolean checkPassword(Player player, String pwdStr) {
        return PasswordProvider.checkPassword(player.getName(), Welcome.getPlugin().getHashAlgorithm().getHash(pwdStr));
    }

    public static boolean setPassword(String playerName, String pwdStr) {
        return passworder.setPassword(playerName, Welcome.getPlugin().getHashAlgorithm().getHash(pwdStr));
    }

    public static boolean setPassword(Player player, String pwdStr) {
        return PasswordProvider.setPassword(player.getName(), Welcome.getPlugin().getHashAlgorithm().getHash(pwdStr));
    }

    public static boolean hasPassword(String playerName) {
        return passworder.hasPassword(playerName);
    }

    public static boolean hasPassword(Player player) {
        return PasswordProvider.hasPassword(player.getName());
    }

    public static boolean removePassword(Player player) {
        return PasswordProvider.removePassword(player.getName());
    }

    public static boolean removePassword(String playerName) {
        return passworder.removePassword(playerName);
    }

    public static String hashPassword(String password) {
        return Welcome.getPlugin().getHashAlgorithm().getHash(password);
    }

    public static boolean checkAutologin(Player player) {
        if (!PasswordProvider.hasPassword(player)) {
            return false;
        }
        if (Welcome.getPlugin().isAutologinDisabled()) {
            return false;
        }
        return passworder.checkAutoLogin(player.getName(), player.getUniqueId().toString(), player.getAddress());
    }

    public static void updateAutologin(Player player) {
        if (!PasswordProvider.hasPassword(player)) {
            return;
        }
        if (Welcome.getPlugin().isAutologinDisabled()) {
            return;
        }
        if (!PlayerManager.isPlayerLoggedIn(player)) {
            return;
        }
        passworder.updateAutoLogin(player.getName(), player.getUniqueId().toString(), player.getAddress());
    }

    public static void removeAutologin(Player player) {
        if (Welcome.getPlugin().isAutologinDisabled()) {
            return;
        }
        if (!PasswordProvider.hasPassword(player)) {
            return;
        }
        if (!PlayerManager.isPlayerLoggedIn(player)) {
            return;
        }
        passworder.updateAutoLogin(player.getName(), player.getUniqueId().toString(), player.getAddress(), 0L);
    }
}

