/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.players;

import cn.nukkit.Player;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.block.SignChangeEvent;
import cn.nukkit.event.inventory.CraftItemEvent;
import cn.nukkit.event.inventory.InventoryCloseEvent;
import cn.nukkit.event.inventory.InventoryOpenEvent;
import cn.nukkit.event.inventory.InventoryPickupArrowEvent;
import cn.nukkit.event.inventory.InventoryPickupItemEvent;
import cn.nukkit.event.player.PlayerAchievementAwardedEvent;
import cn.nukkit.event.player.PlayerAnimationEvent;
import cn.nukkit.event.player.PlayerBedEnterEvent;
import cn.nukkit.event.player.PlayerBedLeaveEvent;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerDropItemEvent;
import cn.nukkit.event.player.PlayerFoodLevelChangeEvent;
import cn.nukkit.event.player.PlayerGameModeChangeEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerInvalidMoveEvent;
import cn.nukkit.event.player.PlayerItemConsumeEvent;
import cn.nukkit.event.player.PlayerItemHeldEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.event.player.PlayerToggleSneakEvent;
import cn.nukkit.event.player.PlayerToggleSprintEvent;
import ru.nukkit.welcome.commands.Commander;
import ru.nukkit.welcome.players.PlayerManager;
import ru.nukkit.welcome.util.Message;

public class ForbidActions
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onSignChange(SignChangeEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryItemPickup(InventoryPickupItemEvent event) {
        for (Player player : event.getViewers()) {
            this.cancel(player, (Cancellable)event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryArrowPickup(InventoryPickupArrowEvent event) {
        for (Player player : event.getViewers()) {
            this.cancel(player, (Cancellable)event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onCraftItemEvent(CraftItemEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerAchievementAwardedEvent(PlayerAchievementAwardedEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerAnimationEvent(PlayerAnimationEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerBedEnterEvent(PlayerBedEnterEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerBedLeaveEvent(PlayerBedLeaveEvent event) {
        if (!PlayerManager.isPlayerLoggedIn(event.getPlayer())) {
            event.setCancelled();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerBucketEmptyEvent(PlayerBucketEmptyEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerBucketFillEvent(PlayerBucketFillEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerChatEvent(PlayerChatEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
        if (event.isCancelled()) {
            Message.debugMessage("PlayerChatEvent is cancelled:", event.getMessage());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        Message.debugMessage("PlayerManager.isPlayerLoggedIn(event.getPlayer()) : " + PlayerManager.isPlayerLoggedIn(event.getPlayer()));
        if (PlayerManager.isPlayerLoggedIn(event.getPlayer())) {
            return;
        }
        String cmd = Commander.getCommandByAlias(event.getMessage().substring(1).split(" ")[0]);
        Message.debugMessage("cmd: " + (cmd == null ? "null" : cmd));
        if (cmd != null && (cmd.equalsIgnoreCase("register") || cmd.equalsIgnoreCase("login"))) {
            return;
        }
        event.setCancelled();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDropItemEvent(PlayerDropItemEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerFoodLevelChangeEvent(PlayerFoodLevelChangeEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerGameModeChangeEvent(PlayerGameModeChangeEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInvalidMoveEvent(PlayerInvalidMoveEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerItemConsumeEvent(PlayerItemConsumeEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerItemHeldEvent(PlayerItemHeldEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerToggleSneakEvent(PlayerToggleSneakEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerToggleSprintEvent(PlayerToggleSprintEvent event) {
        this.cancel(event.getPlayer(), (Cancellable)event);
    }

    private void cancel(Player player, Cancellable event) {
        if (!PlayerManager.isPlayerLoggedIn(player)) {
            event.setCancelled();
        }
    }
}

