/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.welcome.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConfig {
    private Map<String, Object> cfg = new HashMap<String, Object>();

    public void set(String key, Object value) {
        if (key == null || key.isEmpty()) {
            return;
        }
        this.cfg.put(key, value);
        if (value == null) {
            this.cfg.remove(key);
        }
    }

    public Set<String> allKeys() {
        return this.cfg.keySet();
    }

    public Object get(String key, Object defaultValue) {
        return this.cfg.containsKey(key) ? this.cfg.get(key) : defaultValue;
    }

    public Object get(String key) {
        return this.cfg.containsKey(key) ? this.cfg.get(key) : null;
    }

    public void load(File file) throws IOException {
        Yaml yaml = new Yaml();
        FileInputStream in = new FileInputStream(file);
        this.cfg = (Map)yaml.loadAs((InputStream)in, HashMap.class);
        ((InputStream)in).close();
    }

    public void save(File file) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        FileWriter writer = new FileWriter(file);
        yaml.dump(this.cfg, (Writer)writer);
        writer.close();
    }
}

