/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.whereami;

import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.nukkit.whereami.WamiListener;
import ru.nukkit.whereami.commands.Commander;
import ru.nukkit.whereami.util.Message;
import ru.nukkit.whereami.util.Util;

public class WhereAmI
extends PluginBase {
    private static WhereAmI instance;
    private boolean fullInfo;
    String chatMask;
    private Pattern chatMaskPattern;

    public void cfgUpdate() {
        instance = this;
        this.getDataFolder().mkdirs();
        this.reloadConfig();
        this.fullInfo = this.getConfig().getBoolean("where-am-i.show-full-info", false);
        this.getConfig().set("where-am-i.show-full-info", (Object)this.fullInfo);
        this.chatMask = this.getConfig().getString("where-am-i.chat-regex-mask", "(?i)where\\s+am\\s+i");
        this.getConfig().set("where-am-i.chat-regex-mask", (Object)this.chatMask);
        this.chatMaskPattern = Pattern.compile(this.chatMask);
        this.saveConfig();
    }

    public void onEnable() {
        Message.init(this);
        Commander.init(this);
        this.cfgUpdate();
        Util.init();
        this.getServer().getPluginManager().registerEvents((Listener)new WamiListener(), (Plugin)this);
    }

    public static WhereAmI getPlugin() {
        return instance;
    }

    public boolean checkChatMask(String message) {
        Matcher m = this.chatMaskPattern.matcher(message);
        return m.find();
    }

    public boolean fullInfo() {
        return this.fullInfo;
    }
}

