/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.whereami.util;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.level.Location;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.TextFormat;
import java.io.File;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Message {
    LNG_LOAD_FAIL("Failed to load languages from file. Default message used"),
    LNG_SAVE_FAIL("Failed to save lang file"),
    LNG_PRINT_FAIL("Failed to print message %1%. Sender object is null."),
    LNG_CONFIG("[MESSAGES] Messages: %1% Language: %2% Save translate file: %1% Debug mode: %3%"),
    ENABLED("enabled"),
    DISABLED("disabled"),
    WORD_UNKNOWN("Unknown"),
    CMD_WAMI_DESC("Display your current coordinates"),
    YOUR_COORD("Your coordinates: %1%"),
    INFO_DESC("Enable/disable info-mode"),
    INFO_STATE("Coordinate informer is %1%"),
    CORD_SERVER("[Server] Dear %1% your location is: %2%"),
    COORD_WXYZ("%1%"),
    COORD_WXYZPY("%1% pitch:%2% yaw:%3%");

    private static boolean debugMode;
    private static String language;
    private static char c1;
    private static char c2;
    private static PluginBase plugin;
    private String message;
    private Character color1;
    private Character color2;

    public static void BC(Object ... s) {
        if (!debugMode) {
            return;
        }
        if (s.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder("&3[").append(plugin.getDescription().getName()).append("]&f ");
        for (Object str : s) {
            sb.append(str.toString()).append(" ");
        }
        plugin.getServer().broadcastMessage(TextFormat.colorize((String)sb.toString().trim()));
    }

    public boolean log(Object ... s) {
        plugin.getLogger().info(this.getText(s));
        return true;
    }

    public boolean debug(Object ... s) {
        if (debugMode) {
            plugin.getLogger().info(TextFormat.clean((String)this.getText(s)));
        }
        return true;
    }

    public boolean tip(int seconds, CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        final Player player = sender instanceof Player ? (Player)sender : null;
        final String message = this.getText(s);
        if (player == null) {
            sender.sendMessage(message);
        } else {
            for (int i = 0; i < seconds; ++i) {
                Server.getInstance().getScheduler().scheduleDelayedTask(new Runnable(){

                    public void run() {
                        if (player.isOnline()) {
                            player.sendTip(message);
                        }
                    }
                }, 20 * i);
            }
        }
        return true;
    }

    public boolean tip(CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        String message = this.getText(s);
        if (player == null) {
            sender.sendMessage(message);
        } else {
            player.sendTip(message);
        }
        return true;
    }

    public boolean print(CommandSender sender, Object ... s) {
        if (sender == null) {
            return LNG_PRINT_FAIL.log(this.name());
        }
        sender.sendMessage(this.getText(s));
        return true;
    }

    public boolean broadcast(String permission, Object ... s) {
        for (Player player : plugin.getServer().getOnlinePlayers().values()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            this.print((CommandSender)player, s);
        }
        return true;
    }

    public String getText(Object ... keys) {
        char[] colors = new char[]{this.color1 == null ? c1 : this.color1.charValue(), this.color2 == null ? c2 : this.color2.charValue()};
        if (keys.length == 0) {
            return TextFormat.colorize((String)("&" + colors[0] + this.message));
        }
        String str = this.message;
        boolean noColors = false;
        boolean skipDefaultColors = false;
        boolean fullFloat = false;
        int count = 1;
        int c = 0;
        DecimalFormat fmt = new DecimalFormat("####0.##");
        for (int i = 0; i < keys.length; ++i) {
            String s = keys[i].toString();
            if (c < 2 && keys[i] instanceof Character) {
                colors[c] = ((Character)keys[i]).charValue();
                ++c;
                continue;
            }
            if (s.equals("SKIPCOLOR")) {
                skipDefaultColors = true;
                continue;
            }
            if (s.equals("NOCOLORS") || s.equals("NOCOLOR")) {
                noColors = true;
                continue;
            }
            if (s.equals("FULLFLOAT")) {
                fullFloat = true;
                continue;
            }
            if (keys[i] instanceof Location) {
                Location loc = (Location)keys[i];
                s = fullFloat ? loc.getLevel().getName() + "[" + loc.getX() + ", " + loc.getY() + ", " + loc.getZ() + "]" : loc.getLevel().getName() + "[" + fmt.format(loc.getX()) + ", " + fmt.format(loc.getY()) + ", " + fmt.format(loc.getZ()) + "]";
            } else if ((keys[i] instanceof Double || keys[i] instanceof Float) && !fullFloat) {
                s = fmt.format((Double)keys[i]);
            }
            String from = "%" + count + "%";
            String to = skipDefaultColors ? s : "&" + colors[1] + s + "&" + colors[0];
            str = str.replace(from, to);
            ++count;
        }
        str = TextFormat.colorize((String)("&" + colors[0] + str));
        if (noColors) {
            str = TextFormat.clean((String)str);
        }
        return str;
    }

    private void initMessage(String message) {
        this.message = message;
    }

    private Message(String msg) {
        this.message = msg;
        this.color1 = null;
        this.color2 = null;
    }

    private Message(String msg, char color1, char color2) {
        this.message = msg;
        this.color1 = Character.valueOf(color1);
        this.color2 = Character.valueOf(color2);
    }

    private Message(String msg, char color) {
        this(msg, color, color);
    }

    public String toString() {
        return this.getText("NOCOLOR");
    }

    public static void init(PluginBase plg) {
        plugin = plg;
        language = plg.getConfig().getString("general.language", "english");
        plg.getConfig().set("general.language", (Object)language);
        debugMode = plg.getConfig().getBoolean("general.debug-mode", false);
        plg.getConfig().set("general.debug-mode", (Object)debugMode);
        plg.saveConfig();
        Message.initMessages();
        Message.saveMessages();
        LNG_CONFIG.debug(Message.values().length, language, true, debugMode);
    }

    public static void setDebugMode(boolean debug) {
        debugMode = debug;
    }

    private static boolean copyLanguage() {
        return plugin.saveResource("lang/" + language + ".lng", language + ".lng", false);
    }

    private static void initMessages() {
        Message.copyLanguage();
        Config lng = null;
        try {
            File f = new File(plugin.getDataFolder() + File.separator + language + ".lng");
            lng = new Config(f, 2);
        }
        catch (Exception e) {
            LNG_LOAD_FAIL.log(new Object[0]);
            if (debugMode) {
                e.printStackTrace();
            }
            return;
        }
        for (Message key : Message.values()) {
            key.initMessage((String)lng.get(key.name().toLowerCase(), (Object)key.message));
        }
    }

    private static void saveMessages() {
        File f = new File(plugin.getDataFolder() + File.separator + language + ".lng");
        Config lng = new Config(f, 2);
        for (Message key : Message.values()) {
            lng.set(key.name().toLowerCase(), (Object)key.message);
        }
        try {
            lng.save();
        }
        catch (Exception e) {
            LNG_SAVE_FAIL.log(new Object[0]);
            if (debugMode) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static boolean debugMessage(Object ... s) {
        if (debugMode) {
            plugin.getLogger().info(TextFormat.clean((String)Message.join(s)));
        }
        return true;
    }

    public static String join(Object ... s) {
        StringBuilder sb = new StringBuilder();
        for (Object o : s) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    static {
        debugMode = false;
        language = "english";
        c1 = (char)97;
        c2 = (char)50;
        plugin = null;
    }
}

