/*
 * Decompiled with CFR 0.152.
 */
package ru.nukkit.whereami.util;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paginator {
    private List<String> ln;
    private int lpp;
    private String title;
    private String footer;
    private String emptyList;
    private boolean shownum;

    public static void printPage(CommandSender p, List<String> ln, String title, String footer, String emptyMsg, int pageNum, int lpp, boolean shownum) {
        Paginator pg = new Paginator(ln, title, footer, emptyMsg, lpp, shownum);
        pg.printPage(p, pageNum, lpp > 0 ? lpp : (p instanceof Player ? 5 : 1000));
    }

    public void setLinePerPage(int lpp) {
        this.lpp = lpp;
    }

    public Paginator(List<String> ln) {
        this.ln = ln;
        this.lpp = 5;
        this.title = "List";
        this.footer = "Page: %1% / %2%";
        this.emptyList = "List is empty";
        this.shownum = false;
    }

    public Paginator(List<String> ln, String title, String footer, String emptyMsg, int lpp, boolean shownum) {
        this(ln);
        if (lpp > 0) {
            this.lpp = lpp;
        }
        if (title != null && !title.isEmpty()) {
            this.title = title;
        }
        if (footer != null && !footer.isEmpty()) {
            this.footer = footer;
        }
        if (emptyMsg != null && !emptyMsg.isEmpty()) {
            this.emptyList = emptyMsg;
        }
        this.shownum = shownum;
    }

    public void addLine(String str) {
        this.ln.add(str);
    }

    public boolean isEmpty() {
        return this.ln.isEmpty();
    }

    public void setTitle(String title_msgid) {
        this.title = title_msgid;
    }

    public void setShowNum(boolean shownum) {
    }

    public void setFooter(String footer_msgid) {
        this.footer = footer_msgid;
    }

    public void printPage(CommandSender p, int pnum) {
        this.printPage(p, pnum, this.lpp);
    }

    public void printPage(CommandSender p, int pnum, int linesperpage) {
        if (this.ln.size() > 0) {
            int maxp = this.ln.size() / linesperpage;
            if (this.ln.size() % linesperpage > 0) {
                ++maxp;
            }
            if (pnum > maxp) {
                pnum = maxp;
            }
            int maxl = linesperpage;
            if (pnum == maxp) {
                maxl = this.ln.size() % linesperpage;
                if (maxp == 1) {
                    maxl = this.ln.size();
                }
            }
            if (maxl == 0) {
                maxl = linesperpage;
            }
            this.printMsg(p, this.title);
            String numpx = "";
            for (int i = 0; i < maxl; ++i) {
                if (this.shownum) {
                    numpx = "&3" + Integer.toString(1 + i + (pnum - 1) * linesperpage) + ". ";
                }
                this.printMsg(p, numpx + "&a" + this.ln.get(i + (pnum - 1) * linesperpage));
            }
            if (maxp > 1) {
                this.printMsg(p, this.footer.replaceAll("%1%", String.valueOf(pnum)).replaceAll("%2%", String.valueOf(maxp)));
            }
        } else {
            this.printMsg(p, this.emptyList);
        }
    }

    public void printMsg(CommandSender p, String msg) {
        if (p != null && msg != null) {
            p.sendMessage(Paginator.colorize(msg));
        }
    }

    public static String colorize(String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }
}

