/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.worldessentials;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.entity.EntityLevelChangeEvent;
import cn.nukkit.event.player.PlayerDeathEvent;
import cn.nukkit.event.player.PlayerGameModeChangeEvent;
import cn.nukkit.level.Level;
import cn.nukkit.utils.Config;
import cn.yescallop.worldessentials.WorldEssentials;

public class EventListener
implements Listener {
    WorldEssentials plugin;

    public EventListener(WorldEssentials plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityLevelChange(EntityLevelChangeEvent event) {
        Level target;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level origin = event.getOrigin();
        if (origin.equals(target = event.getTarget())) {
            return;
        }
        this.plugin.setPlayerInfos(player);
        int gamemode = this.plugin.getPlayerGamemode(player, target);
        player.setGamemode(gamemode);
        player.getInventory().setContents(this.plugin.getPlayerInventoryContents(player, gamemode, target));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        Config playerConfig = this.plugin.getPlayerConfig(player, player.getLevel());
        playerConfig.set("inventories", this.plugin.getPlayerInventories(player, player.getLevel()));
        playerConfig.save();
        int gamemode = event.getNewGamemode();
        player.getInventory().setContents(this.plugin.getPlayerInventoryContents(player, gamemode, player.getLevel()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (this.plugin.getLevelBooleanGamerule(event.getEntity().getLevel(), "keepInventory")) {
            event.setKeepInventory(true);
            event.setKeepExperience(true);
        }
    }
}

