/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.worldessentials;

import cn.nukkit.Player;
import cn.nukkit.event.Listener;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.Config;
import cn.yescallop.worldessentials.EventListener;
import cn.yescallop.worldessentials.command.CommandManager;
import cn.yescallop.worldessentials.lang.BaseLang;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class WorldEssentials
extends PluginBase {
    private File worldsFolder;
    private BaseLang lang;

    public void onEnable() {
        this.getDataFolder().mkdirs();
        this.worldsFolder = new File(this.getDataFolder(), "worlds");
        this.worldsFolder.mkdirs();
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
        this.lang = new BaseLang(this.getServer().getLanguage().getLang());
        CommandManager.registerAll(this);
        this.getLogger().info(this.lang.translateString("worldessentials.loaded"));
    }

    public BaseLang getLanguage() {
        return this.lang;
    }

    public Location getPlayerSpawn(Player player, Level level) {
        LinkedHashMap infos = (LinkedHashMap)this.getPlayerConfig(player, level).getAll();
        Object pos = infos.size() == 0 ? level.getSafeSpawn() : new Vector3(((Double)infos.get("x")).doubleValue(), ((Double)infos.get("y")).doubleValue(), ((Double)infos.get("z")).doubleValue());
        return Location.fromObject((Vector3)pos, (Level)level);
    }

    public void setLevelGamemode(Level level, int gamemode) {
        Config levelConfig = this.getLevelConfig(level);
        levelConfig.set("gamemode", (Object)gamemode);
        levelConfig.save();
        for (Config playerConfig : this.getLevelPlayerConfigs(level)) {
            playerConfig.set("gamemode", (Object)gamemode);
            playerConfig.save();
        }
        for (Player levelPlayer : level.getPlayers().values()) {
            levelPlayer.setGamemode(gamemode);
        }
    }

    public int getPlayerGamemode(Player player, Level level) {
        return this.getPlayerConfig(player, level).getInt("gamemode", this.getLevelGamemode(level));
    }

    public LinkedHashMap<Integer, Item> getPlayerInventoryContents(Player player, int gamemode, Level level) {
        LinkedHashMap inventory;
        LinkedHashMap inventories = (LinkedHashMap)this.getPlayerConfig(player, level).get("inventories");
        if (inventories == null) {
            return new LinkedHashMap<Integer, Item>();
        }
        switch (gamemode) {
            case 0: {
                inventory = (LinkedHashMap)inventories.get("survival");
                break;
            }
            case 1: {
                inventory = (LinkedHashMap)inventories.get("creative");
                break;
            }
            default: {
                return new LinkedHashMap<Integer, Item>();
            }
        }
        if (inventory == null) {
            return new LinkedHashMap<Integer, Item>();
        }
        LinkedHashMap<Integer, Item> contents = new LinkedHashMap<Integer, Item>();
        for (Map.Entry entry : inventory.entrySet()) {
            ArrayList item = (ArrayList)entry.getValue();
            contents.put((Integer)entry.getKey(), Item.get((int)((Integer)item.get(0)), (Integer)((Integer)item.get(1)), (int)((Integer)item.get(2))));
        }
        return contents;
    }

    public void setLevelGamerule(Level level, String gamerule, Object value) {
        Config levelConfig = this.getLevelConfig(level);
        LinkedHashMap gamerules = (LinkedHashMap)levelConfig.get("gamerules", new LinkedHashMap());
        gamerules.put(gamerule, value);
        levelConfig.set("gamerules", (Object)gamerules);
        levelConfig.save();
    }

    public boolean getLevelBooleanGamerule(Level level, String gamerule) {
        LinkedHashMap gamerules = (LinkedHashMap)this.getLevelConfig(level).get("gamerules", new LinkedHashMap());
        return gamerules.getOrDefault(gamerule, false);
    }

    public int getLevelGamemode(Level level) {
        return this.getLevelConfig(level).getInt("gamemode", this.getServer().getDefaultGamemode());
    }

    public void setPlayerInfos(final Player player) {
        Config playerConfig = this.getPlayerConfig(player, player.getLevel());
        LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>(){
            {
                this.put("x", player.x);
                this.put("y", player.y);
                this.put("z", player.z);
                this.put("inventories", WorldEssentials.this.getPlayerInventories(player, player.getLevel()));
                this.put("gamemode", player.getGamemode());
            }
        };
        playerConfig.setAll((LinkedHashMap)infos);
        playerConfig.save();
    }

    public LinkedHashMap<String, LinkedHashMap<Integer, Object>> getPlayerInventories(Player player, Level level) {
        LinkedHashMap<Integer, int[]> inventory = new LinkedHashMap<Integer, int[]>();
        for (Map.Entry entry : player.getInventory().getContents().entrySet()) {
            Item item = (Item)entry.getValue();
            inventory.put((Integer)entry.getKey(), new int[]{item.getId(), item.getDamage(), item.getCount()});
        }
        Config playerConfig = this.getPlayerConfig(player, player.getLevel());
        LinkedHashMap inventories = (LinkedHashMap)playerConfig.get("inventories", new LinkedHashMap());
        switch (player.getGamemode()) {
            case 0: {
                inventories.put("survival", inventory);
                break;
            }
            case 1: {
                inventories.put("creative", inventory);
            }
        }
        return inventories;
    }

    public Config getLevelConfig(Level level) {
        return new Config(new File(this.worldsFolder, level.getName() + ".yml"), 2);
    }

    public Config getPlayerConfig(Player player, Level level) {
        return new Config(new File(this.getLevelFolder(level), player.getName().toLowerCase() + ".yml"), 2);
    }

    public Config[] getLevelPlayerConfigs(Level level) {
        File[] files = this.getLevelFolder(level).listFiles();
        ArrayList<Config> configs = new ArrayList<Config>();
        for (File file : files) {
            configs.add(new Config(file, 2));
        }
        return configs.toArray(new Config[0]);
    }

    public File getLevelFolder(Level level) {
        File folder = new File(this.worldsFolder, level.getName());
        folder.mkdirs();
        return folder;
    }
}

