/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.worldessentials.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Level;
import cn.nukkit.utils.TextFormat;
import cn.yescallop.worldessentials.WorldEssentials;
import cn.yescallop.worldessentials.command.CommandBase;

public class SetWorldGamemodeCommand
extends CommandBase {
    public SetWorldGamemodeCommand(WorldEssentials plugin) {
        super("setworldgamemode", plugin);
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        int gamemode;
        Level level;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((TextContainer)new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        if (args.length > 1) {
            level = this.plugin.getServer().getLevelByName(args[1]);
            if (level == null) {
                sender.sendMessage(TextFormat.RED + this.lang.translateString("commands.generic.level.notFound", args[1]));
                return true;
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(TextFormat.RED + this.lang.translateString("commands.generic.onlyInGame"));
                return true;
            }
            level = ((Player)sender).getLevel();
        }
        if ((gamemode = Server.getGamemodeFromString((String)args[0])) == -1) {
            sender.sendMessage(TextFormat.RED + this.lang.translateString("commands.setworldgamemode.unknownGamemode", args[0]));
            return true;
        }
        this.plugin.setLevelGamemode(level, gamemode);
        for (Player levelPlayer : level.getPlayers().values()) {
            levelPlayer.sendMessage(this.lang.translateString("commands.setworldgamemode.success.others", Server.getGamemodeString((int)gamemode)));
        }
        sender.sendMessage(this.lang.translateString("commands.setworldgamemode.success", new String[]{level.getName(), Server.getGamemodeString((int)gamemode)}));
        return true;
    }
}

