/*
 * Decompiled with CFR 0.152.
 */
package cn.yescallop.worldessentials.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Level;
import cn.nukkit.utils.TextFormat;
import cn.yescallop.worldessentials.WorldEssentials;
import cn.yescallop.worldessentials.command.CommandBase;

public class TpwCommand
extends CommandBase {
    public TpwCommand(WorldEssentials plugin) {
        super("tpw", plugin);
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        Level level;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((TextContainer)new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        CommandSender target = sender;
        if (args.length > 1) {
            if (!sender.hasPermission("worldessentials.command.tpw.other")) {
                sender.sendMessage((TextContainer)new TranslationContainer(TextFormat.RED + "%commands.generic.permission"));
                return true;
            }
            target = this.plugin.getServer().getPlayer(args[1]);
            if (target == null) {
                sender.sendMessage(TextFormat.RED + this.lang.translateString("commands.tpw.player.notFound", args[1]));
                return true;
            }
        } else if (!(sender instanceof Player)) {
            sender.sendMessage(TextFormat.RED + this.lang.translateString("commands.generic.onlyPlayer"));
            return true;
        }
        if ((level = this.plugin.getServer().getLevelByName(args[0])) == null) {
            sender.sendMessage(TextFormat.RED + this.lang.translateString("commands.generic.level.notFound", args[0]));
            return true;
        }
        Player player = (Player)target;
        this.plugin.setPlayerInfos(player);
        player.teleport(this.plugin.getPlayerSpawn(player, level));
        int gamemode = this.plugin.getPlayerGamemode(player, level);
        player.setGamemode(gamemode);
        player.getInventory().setContents(this.plugin.getPlayerInventoryContents(player, gamemode, level));
        return true;
    }
}

