/*
 * Decompiled with CFR 0.152.
 */
package com.joshuahuelsman.patchtool;

import com.joshuahuelsman.patchtool.PTPatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Main {
    public static byte[] defaultip;

    static {
        byte[] byArray = new byte[29];
        byArray[0] = -1;
        byArray[1] = 80;
        byArray[2] = 84;
        byArray[3] = 80;
        byArray[4] = -65;
        byArray[5] = 1;
        byArray[9] = 10;
        byArray[11] = 23;
        byArray[12] = -69;
        byArray[13] = 36;
        defaultip = byArray;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("PTPatchTool: a tool to manipulate the PTPatch format");
            System.out.println("Visit http://www.minecraftforum.net/topic/1112628-mod-patching/ for usage.");
            return;
        }
        if (args[0].equals("-cl")) {
            int num_patches = args.length - 1;
            String[] patches = new String[num_patches];
            int i = 0;
            while (i < num_patches) {
                patches[i] = args[i + 1];
                ++i;
            }
            try {
                Main.combine_legacy(num_patches, patches);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (args[0].equals("-s")) {
            Main.sendViaADB(args[1]);
        } else if (args[0].equals("-ip")) {
            try {
                Main.generateIPPatch(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (args[0].equals("diff")) {
            try {
                Main.diff(args[1], args[2], args.length <= 3 ? null : args[3].getBytes(Charset.forName("UTF-8")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (args[0].equals("patch")) {
            try {
                Main.applyPatchTo(args[1], args[2]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Incorrect command line.");
        }
    }

    public static void combine_legacy(int num, String[] patches) throws IOException {
        byte[][] patch_array = new byte[num][];
        int i = 0;
        while (i < num) {
            try {
                patch_array[i] = Main.readPatch(i, patches);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        File out = new File("patch.mod");
        out.delete();
        FileOutputStream os = new FileOutputStream(out);
        Main.writeMagic(os);
        Main.writeVersionCode(0, os);
        Main.writeNumberPatches(num, os);
        ((OutputStream)os).write(Main.generateIndices(num, patch_array));
        ((OutputStream)os).write(Main.mergeAndStripHeaderData(num, patch_array));
        ((OutputStream)os).close();
    }

    public static void writeMagic(OutputStream os) throws IOException {
        byte[] magic = new byte[]{-1, 80, 84, 80};
        os.write(magic);
    }

    public static void writeVersionCode(int vc, OutputStream os) throws IOException {
        os.write(vc);
    }

    public static void writeNumberPatches(int num, OutputStream os) throws IOException {
        os.write(num);
    }

    public static byte[] generateIndices(int num, byte[][] patchData) {
        byte[] ret = new byte[num * 4];
        int headerSize = 6 + num * 4;
        int bloat = 0;
        int i = 0;
        while (i < num) {
            int temp = headerSize;
            byte[] data = new byte[4];
            if (i == 0) {
                bloat += patchData[i].length - 5;
                data = Main.intToByteArray(temp);
                ret[i * 4] = data[0];
                ret[i * 4 + 1] = data[1];
                ret[i * 4 + 2] = data[2];
                ret[i * 4 + 3] = data[3];
            } else {
                data = Main.intToByteArray(temp += bloat);
                ret[i * 4] = data[0];
                ret[i * 4 + 1] = data[1];
                ret[i * 4 + 2] = data[2];
                ret[i * 4 + 3] = data[3];
                bloat += patchData[i].length - 5;
            }
            ++i;
        }
        return ret;
    }

    public static byte[] generateIndices(byte[][] patchData, int padding) {
        byte[] ret = new byte[patchData.length * 4];
        int headerSize = 6 + patchData.length * 4 + padding;
        int bloat = 0;
        int i = 0;
        while (i < patchData.length) {
            int temp = headerSize;
            byte[] data = new byte[4];
            if (i == 0) {
                bloat += patchData[i].length;
                data = Main.intToByteArray(temp);
                ret[i * 4] = data[0];
                ret[i * 4 + 1] = data[1];
                ret[i * 4 + 2] = data[2];
                ret[i * 4 + 3] = data[3];
            } else {
                data = Main.intToByteArray(temp += bloat);
                ret[i * 4] = data[0];
                ret[i * 4 + 1] = data[1];
                ret[i * 4 + 2] = data[2];
                ret[i * 4 + 3] = data[3];
                bloat += patchData[i].length;
            }
            ++i;
        }
        return ret;
    }

    public static byte[] mergeAndStripHeaderData(int num, byte[][] patchData) {
        int size = 0;
        int i = 0;
        while (i < num) {
            size += patchData[i].length - 5;
            ++i;
        }
        byte[] ret = new byte[size];
        int count = 0;
        int i2 = 0;
        int i22 = 0;
        while (i2 < num) {
            i22 = 0;
            while (i22 < patchData[i2].length - 5) {
                ret[count] = patchData[i2][i22 + 5];
                ++count;
                ++i22;
            }
            ++i2;
        }
        return ret;
    }

    public static byte[] readPatch(int index, String[] patches) throws IOException {
        File patch = new File(patches[index]);
        byte[] ret = new byte[(int)patch.length()];
        FileInputStream is = new FileInputStream(patches[index]);
        ((InputStream)is).read(ret, 0, ret.length);
        ((InputStream)is).close();
        return ret;
    }

    public static byte[] readPatch(String patch) throws IOException {
        File patchf = new File(patch);
        byte[] ret = new byte[(int)patchf.length()];
        FileInputStream is = new FileInputStream(patch);
        ((InputStream)is).read(ret, 0, ret.length);
        ((InputStream)is).close();
        return ret;
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static void sendViaADB(String patch) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("adb push " + patch + " /mnt/sdcard");
            BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = bri.readLine()) != null) {
                System.out.println(line);
            }
            bri.close();
            while ((line = bre.readLine()) != null) {
                System.out.println(line);
            }
            bre.close();
            p.waitFor();
            System.out.println("Done.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void generateIPPatch(String ip) throws IOException {
        FileOutputStream out = new FileOutputStream(new File("patch.mod"));
        ByteBuffer buf = ByteBuffer.wrap(defaultip);
        buf.position(14);
        buf.put(ip.getBytes());
        ((OutputStream)out).write(buf.array());
        ((OutputStream)out).close();
    }

    public static void applyPatchTo(String fileLoc, String patchLoc) throws IOException {
        PTPatch patch = new PTPatch(patchLoc);
        patch.loadPatch();
        System.out.println(String.valueOf(patchLoc) + ": Minecraft version: " + Integer.toString(patch.mHeader.minecraft_ver, 16));
        System.out.println("Number of locations in patch: " + patch.mHeader.num_patches);
        if (!patch.checkMagic()) {
            System.err.println("Magic error!");
            return;
        }
        System.out.println("Magic OK.");
        File file = new File(fileLoc);
        patch.applyPatch(file);
        System.out.println("Done patching.");
    }

    public static void diff(String oldf, String newf, byte[] metaData) throws IOException {
        int i;
        byte[] newData;
        byte[] oldData = Main.readPatch(oldf);
        if (oldData.length != (newData = Main.readPatch(newf)).length) {
            System.out.println("Error: The new file's length does not match the old file's length. Aborting...");
            return;
        }
        File out = new File("patch.mod");
        out.delete();
        FileOutputStream os = new FileOutputStream(out);
        Main.writeMagic(os);
        Main.writeVersionCode(0, os);
        int numPatches = 0;
        int i2 = 0;
        while (i2 < oldData.length) {
            if (oldData[i2] != newData[i2]) {
                ++numPatches;
                while (oldData[i2] != newData[i2]) {
                    ++i2;
                }
            }
            ++i2;
        }
        System.out.println("Number of Patches: " + numPatches);
        Main.writeNumberPatches(numPatches, os);
        byte[][] patchData = new byte[numPatches][];
        int index = 0;
        int[] address = new int[numPatches];
        int i22 = 0;
        while (i22 < numPatches) {
            i = index;
            while (i < oldData.length) {
                if (oldData[i] != newData[i]) {
                    address[i22] = i;
                    int i3 = 0;
                    while (oldData[i] != newData[i]) {
                        ++i;
                        ++i3;
                    }
                    patchData[i22] = new byte[i3 + 4];
                    System.out.println("Length of patch " + i22 + ": " + (i3 + 4));
                    index = i;
                    break;
                }
                ++i;
            }
            ++i22;
        }
        index = 0;
        i22 = 0;
        while (i22 < numPatches) {
            i = index;
            while (i < oldData.length) {
                if (oldData[i] != newData[i]) {
                    byte[] addr = Main.intToByteArray(i);
                    patchData[i22][0] = addr[0];
                    patchData[i22][1] = addr[1];
                    patchData[i22][2] = addr[2];
                    patchData[i22][3] = addr[3];
                    while (oldData[i] != newData[i]) {
                        ++i;
                    }
                    index = i;
                    break;
                }
                ++i;
            }
            ++i22;
        }
        i22 = 0;
        while (i22 < numPatches) {
            i = 0;
            while (i < patchData[i22].length - 4) {
                patchData[i22][i + 4] = newData[address[i22] + i];
                ++i;
            }
            ++i22;
        }
        ((OutputStream)os).write(Main.generateIndices(patchData, metaData != null ? metaData.length : 0));
        if (metaData != null) {
            ((OutputStream)os).write(metaData);
        }
        int i3 = 0;
        while (i3 < numPatches) {
            ((OutputStream)os).write(patchData[i3]);
            ++i3;
        }
        ((OutputStream)os).close();
    }
}

