/*
 * Decompiled with CFR 0.152.
 */
package com.joshuahuelsman.patchtool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class PTPatch {
    public static final byte[] magic = new byte[]{-1, 80, 84, 80};
    public static final byte[] op_codes = new byte[]{-86, -35, -18};
    private byte[] patch_array;
    private int count;
    private String location;
    public String name;
    Header mHeader;

    public PTPatch(String loc) {
        this.location = loc;
        this.mHeader = new Header();
    }

    public void loadPatch() throws IOException {
        File patchf = new File(this.location);
        this.patch_array = new byte[(int)patchf.length()];
        FileInputStream is = new FileInputStream(patchf);
        ((InputStream)is).read(this.patch_array);
        ((InputStream)is).close();
        this.mHeader.minecraft_ver = this.getMinecraftVersion();
        this.mHeader.num_patches = this.getNumPatches();
        this.mHeader.indices = this.getIndices();
        this.count = 0;
    }

    public int getMinecraftVersion() {
        return this.patch_array[4];
    }

    public int getNumPatches() {
        return this.patch_array[5];
    }

    public byte[] getIndices() {
        byte[] ret = new byte[this.mHeader.num_patches * 4];
        int i = 0;
        while (i < this.mHeader.num_patches * 4) {
            ret[i] = this.patch_array[i + 6];
            ++i;
        }
        return ret;
    }

    public boolean checkMagic() {
        return this.patch_array[0] == magic[0] && this.patch_array[1] == magic[1] && this.patch_array[2] == magic[2] && this.patch_array[3] == magic[3];
    }

    public void checkMinecraftVersion() {
    }

    public int getNextAddr() {
        byte[] i = new byte[]{this.mHeader.indices[this.count * 4], this.mHeader.indices[this.count * 4 + 1], this.mHeader.indices[this.count * 4 + 2], this.mHeader.indices[this.count * 4 + 3]};
        int index = PTPatch.byteArrayToInt(i);
        byte[] b = new byte[]{this.patch_array[index], this.patch_array[index + 1], this.patch_array[index + 2], this.patch_array[index + 3]};
        return PTPatch.byteArrayToInt(b);
    }

    public int getCurrentIndex() {
        byte[] i = new byte[]{this.mHeader.indices[this.count * 4], this.mHeader.indices[this.count * 4 + 1], this.mHeader.indices[this.count * 4 + 2], this.mHeader.indices[this.count * 4 + 3]};
        int index = PTPatch.byteArrayToInt(i);
        return index;
    }

    public byte[] getNextData() {
        byte[] array = new byte[this.getDataLength()];
        int index = this.getCurrentIndex();
        int i2 = 0;
        int i = 0;
        while (i < this.getDataLength()) {
            array[i2] = this.patch_array[i + (index + 4)];
            ++i2;
            ++i;
        }
        return array;
    }

    public int getDataLength() {
        int start = 0;
        int end = 0;
        byte[] i = new byte[]{this.mHeader.indices[this.count * 4], this.mHeader.indices[this.count * 4 + 1], this.mHeader.indices[this.count * 4 + 2], this.mHeader.indices[this.count * 4 + 3]};
        if (this.count != this.mHeader.num_patches - 1) {
            byte[] i2 = new byte[]{this.mHeader.indices[(this.count + 1) * 4], this.mHeader.indices[(this.count + 1) * 4 + 1], this.mHeader.indices[(this.count + 1) * 4 + 2], this.mHeader.indices[(this.count + 1) * 4 + 3]};
            end = PTPatch.byteArrayToInt(i2);
        } else {
            end = this.patch_array.length;
        }
        start = PTPatch.byteArrayToInt(i) + 4;
        return end - start;
    }

    public void applyPatch(File f) throws IOException {
        byte[] barray = new byte[(int)f.length()];
        FileInputStream is = new FileInputStream(f);
        ((InputStream)is).read(barray);
        ((InputStream)is).close();
        ByteBuffer buf = ByteBuffer.wrap(barray);
        this.count = 0;
        while (this.count < this.mHeader.num_patches) {
            buf.position(this.getNextAddr());
            buf.put(this.getNextData());
            ++this.count;
        }
        f.delete();
        FileOutputStream os = new FileOutputStream(f);
        ((OutputStream)os).write(buf.array());
        ((OutputStream)os).close();
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static byte[] readPatch(String patch) throws IOException {
        File patchf = new File(patch);
        byte[] ret = new byte[(int)patchf.length()];
        FileInputStream is = new FileInputStream(patch);
        ((InputStream)is).read(ret, 0, ret.length);
        ((InputStream)is).close();
        return ret;
    }

    class Header {
        byte[] magic = new byte[4];
        int minecraft_ver;
        int num_patches;
        byte[] indices;

        Header() {
        }
    }
}

