/*
 * Decompiled with CFR 0.152.
 */
package org.pldrjs.pldrjs;

import cn.nukkit.Server;
import cn.nukkit.event.Event;
import cn.nukkit.plugin.PluginBase;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;

public class PldrJS
extends PluginBase {
    public File baseFolder = new File("scripts/");
    public File modulesFolder = new File(this.baseFolder, "node_modules");
    public CompiledScript commonjs;
    public String[] ignorantFiles = new String[]{"jvm-npm.js", "pldr.js"};
    public Map<String, Class<? extends Event>> knownEvents = new HashMap<String, Class<? extends Event>>();
    public Map<String, String> scripts = new HashMap<String, String>();
    private static PldrJS instance = null;
    private ScriptEngine engine = null;
    private ScriptContext ctx = null;
    public boolean isStopRequested = false;
    private boolean updateRequired = false;
    private Thread t = new Thread(() -> {
        while (!this.isStopRequested) {
            try {
                this.engine.eval("$$.tickHook();", this.ctx);
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    });

    public static PldrJS getInstance() {
        return instance;
    }

    public boolean exportResource(String resourceName, File target) throws Exception {
        if (!target.exists()) {
            Files.copy(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName), target.toPath(), new CopyOption[0]);
            return true;
        }
        return false;
    }

    public void onDisable() {
        this.isStopRequested = true;
        if (this.updateRequired) {
            new File(this.baseFolder, "jvm-npm.js").delete();
            new File(this.baseFolder, "pldr.js").delete();
            new File(this.baseFolder, "package.json").delete();
            this.deleteFolder(this.modulesFolder);
            return;
        }
        try {
            this.engine.eval("$$.disabledHook();", this.ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteFolder(File f) {
        File[] innerFiles = f.listFiles();
        if (innerFiles.length <= 0) {
            return;
        }
        Arrays.asList(innerFiles).forEach(v -> {
            if (v.isDirectory()) {
                this.deleteFolder((File)v);
            } else {
                v.delete();
            }
        });
        f.delete();
    }

    private List<String> findClass(String parentPackage) throws Exception {
        LinkedList<String> files = new LinkedList<String>();
        String packageName = parentPackage.replace(".", "/");
        URL resources = Server.class.getClassLoader().getResources(packageName).nextElement();
        if (!resources.toString().startsWith("jar")) {
            for (File dir : new File(resources.getFile()).listFiles()) {
                if (!dir.isDirectory()) continue;
                for (File v : dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isFile();
                    }
                })) {
                    files.add(packageName + "/" + dir.getName() + "/" + v.getName());
                }
            }
        } else {
            Enumeration<JarEntry> iter = ((JarURLConnection)resources.openConnection()).getJarFile().entries();
            while (iter.hasMoreElements()) {
                files.add(iter.nextElement().getName());
            }
        }
        return files.stream().filter(file -> {
            if (file.contains("$")) {
                return false;
            }
            return file.endsWith(".class") && file.startsWith(packageName);
        }).collect(Collectors.toList());
    }

    public void onEnable() {
        instance = this;
        this.engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (!this.baseFolder.exists()) {
            this.baseFolder.mkdir();
        }
        boolean test = System.getenv("PLDR_ENVIRONMENT") != null && System.getenv("PLDR_ENVIRONMENT").toLowerCase().equals("development");
        try {
            ZipEntry entry;
            this.exportResource("commonjs/src/main/javascript/jvm-npm.js", new File(this.baseFolder, "jvm-npm.js"));
            this.exportResource("pldr.js", new File(this.baseFolder, "pldr.js"));
            this.exportResource("package.json", new File(this.baseFolder, "package.json"));
            if (!this.modulesFolder.exists()) {
                this.modulesFolder.mkdir();
            }
            InputStream defaultModules = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("default_modules.zip");
            ZipInputStream zis = new ZipInputStream(defaultModules);
            while ((entry = zis.getNextEntry()) != null) {
                File target = new File(this.modulesFolder, entry.getName());
                if (target.exists()) continue;
                if (entry.isDirectory()) {
                    target.mkdir();
                } else {
                    Files.copy(zis, target.toPath(), new CopyOption[0]);
                }
                zis.closeEntry();
            }
        }
        catch (Exception e) {
            this.getLogger().error("\ub9ac\uc18c\uc2a4 \ucd94\ucd9c \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
            return;
        }
        try {
            String packagedPackage;
            String packagedVersion;
            this.getLogger().info("\u00a7b\uc5c5\ub370\uc774\ud2b8 \uccb4\ud06c\uc911.... \uc2dc\uac04\uc774 \uc624\ub798 \uac78\ub9b4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
            URL versionCheck = new URL("https://raw.githubusercontent.com/pldrjs/pldr.js/master/package.json");
            String serverPackage = new BufferedReader(new InputStreamReader(versionCheck.openStream())).lines().collect(Collectors.joining("\n"));
            Gson gson = new Gson();
            JsonParser parser = new JsonParser();
            String serverVersion = (String)gson.fromJson(parser.parse(serverPackage).getAsJsonObject().get("version"), String.class);
            String localPackage = Files.lines(new File(this.baseFolder, "package.json").toPath()).collect(Collectors.joining("\n"));
            String localVersion = (String)gson.fromJson(parser.parse(localPackage).getAsJsonObject().get("version"), String.class);
            if (!localVersion.equals(serverVersion)) {
                this.getLogger().warning("\uc5c5\ub370\uc774\ud2b8\uac00 \ubc1c\uacac\ub418\uc5c8\uc2b5\ub2c8\ub2e4!");
            }
            if (!localVersion.equals(packagedVersion = (String)gson.fromJson(parser.parse(packagedPackage = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("package.json"))).lines().collect(Collectors.joining("\n"))).getAsJsonObject().get("version"), String.class))) {
                this.getLogger().info("\u00a7bpldr.js\ub294 \uc5c5\ub370\uc774\ud2b8 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                this.updateRequired = true;
                this.getLogger().info("\u00a7bpldr.js\uc758 \uc5c5\ub370\uc774\ud2b8\ub97c \ub05d\ub9c8\uce58\uae30 \uc704\ud574 \uc11c\ubc84\ub97c \uc885\ub8cc\ud569\ub2c8\ub2e4. \ub2e4\uc2dc \uc2dc\uc791\ud558\uc5ec\uc8fc\uc138\uc694.");
                this.getServer().shutdown();
                return;
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\uc5c5\ub370\uc774\ud2b8 \uccb4\ud06c \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            this.commonjs = ((Compilable)((Object)this.engine)).compile(new FileReader(new File(this.baseFolder, "jvm-npm.js")));
        }
        catch (Exception e) {
            this.getLogger().error("jvm-npm \uc2a4\ud06c\ub9bd\ud2b8\ub97c \ucef4\ud30c\uc77c \ud558\ub358 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
        }
        try {
            this.findClass("cn.nukkit.event").forEach(file -> {
                String[] split = file.split("/");
                if (split.length != 5) {
                    return;
                }
                if (!split[2].equals("event")) {
                    return;
                }
                String category = split[3];
                String className = split[4].substring(0, split[4].length() - 6);
                if (file.equals("cn/nukkit/event/" + category + "/" + category.substring(0, 1).toUpperCase() + category.substring(1) + "Event.class")) {
                    return;
                }
                try {
                    String eventName = className.substring(0, className.length() - 5).toLowerCase();
                    if (this.knownEvents.containsKey(eventName)) {
                        return;
                    }
                    this.knownEvents.put(eventName, Class.forName(file.substring(0, file.length() - 6).replace("/", ".")));
                }
                catch (Exception e) {
                    this.getLogger().error("\uc774\ubca4\ud2b8 \ubaa9\ub85d\uc744 \uc21c\ud658 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.getLogger().error("\uc774\ubca4\ud2b8\ub97c \ucc3e\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
        }
        Arrays.asList(this.baseFolder.listFiles()).forEach(f -> {
            try {
                if (!f.isFile() || !f.getName().endsWith(".js") || !test && Arrays.asList(this.ignorantFiles).contains(f.getName())) {
                    return;
                }
                String[] split = f.getName().split("\\.");
                String name = IntStream.range(0, split.length).filter(v -> v != split.length - 1).mapToObj(v -> split[v]).collect(Collectors.joining("."));
                this.scripts.put(name, Files.lines(f.toPath()).collect(Collectors.joining("\n")));
            }
            catch (Exception e) {
                this.getLogger().error("\uc2a4\ud06c\ub9bd\ud2b8\ub97c \uc77d\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
            }
        });
        try {
            this.ctx = new SimpleScriptContext();
            this.ctx.getBindings(100).put("PldrJSPlugin", (Object)PldrJS.getInstance());
            this.ctx.getBindings(100).put("PldrJSEvents", (Object)this.knownEvents);
            this.ctx.getBindings(100).put("PldrJSScripts", (Object)this.scripts);
            this.commonjs.eval(this.ctx);
            this.engine.eval(Files.lines(new File(this.baseFolder, "node_modules/babel-polyfill/dist/polyfill.min.js").toPath()).collect(Collectors.joining("\n")), this.ctx);
            this.engine.eval("require.root = \"" + this.baseFolder.getAbsolutePath().replace("\\", "\\\\") + "\";", this.ctx);
            try {
                this.engine.eval("var PldrJS = require('./pldr');\nvar $$ = PldrJS;", this.ctx);
            }
            catch (Exception e) {
                this.getLogger().error("pldr.js \uc2a4\ud06c\ub9bd\ud2b8 \uc2dc\uc791 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
            }
            this.scripts.forEach((k, v) -> {
                try {
                    this.engine.eval("Function(PldrJSScripts.get('" + k.replace("'", "\\'") + "'))()", this.ctx);
                    this.getLogger().info("\u00a7b" + k + "\uc2a4\ud06c\ub9bd\ud2b8\uac00 \uc131\uacf5\uc801\uc73c\ub85c \ub85c\ub529\ub410\uc2b5\ub2c8\ub2e4.");
                }
                catch (Exception e) {
                    this.getLogger().error(k + " \uc2a4\ud06c\ub9bd\ud2b8\uc5d0 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4.", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.getLogger().error("\uc2a4\ud06c\ub9bd\ud2b8\ub4e4\uc744 \uc2e4\ud589\uc2dc\ud0a4\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)e);
        }
        if (!test) {
            this.t.setName("PldrJS modTick Thread");
            this.t.start();
        }
    }
}

