/*
 * Decompiled with CFR 0.152.
 */
package com.fleynaro.treecap;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.entity.EntityExplodeEvent;
import com.fleynaro.treecap.Main;
import com.fleynaro.treecap.TreeEntity;

public class EventListener
implements Listener {
    EventListener() {
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onBreak(BlockBreakEvent event) {
        TreeEntity tree;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        boolean axeInHand = TreeEntity.IsPlayerWithAxInHand(player);
        if (player != null && (!Main.config.getBoolean("only-axe", true) || axeInHand) && TreeEntity.IsBlockOfTree(block) && (tree = TreeEntity.GetTreeOfBlock(block)).isTree()) {
            if (tree.canBeCutDown()) {
                if (tree.hitToCutDown()) {
                    tree.removeBlock(block);
                    tree.cutDown();
                } else {
                    event.setCancelled();
                }
                if (axeInHand) {
                    TreeEntity.BreakPlayerAxe(player);
                }
            } else {
                tree.removeBlock(block);
            }
        }
    }

    @EventHandler
    public void onExplosion(EntityExplodeEvent event) {
        for (Block block : event.getBlockList()) {
        }
    }
}

