/*
 * Decompiled with CFR 0.152.
 */
package com.fleynaro.treecap;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import com.fleynaro.treecap.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeEntity {
    public static Map<Block, TreeEntity> trees = new HashMap<Block, TreeEntity>();
    public Type tree;
    public List<Block> blocks = new ArrayList<Block>();
    public List<Block> leaves = new ArrayList<Block>();
    public Level level;
    public int downHeight;
    public int upHeight;
    public Block brokenBlock;
    public int cutDownCount = 0;

    TreeEntity(Block block) {
        this.level = block.getLevel();
        this.tree = TreeEntity.getTree(block);
        this.brokenBlock = block;
        this.getBlocks(block);
        if (this.isTree()) {
            if (this.isValid()) {
                for (Block wood : this.blocks) {
                    trees.put(wood, this);
                }
            } else {
                this.tree = null;
            }
        }
    }

    public void setBrokenBlock(Block block) {
        if (block == this.brokenBlock) {
            return;
        }
        int differ = block.getFloorZ() - this.brokenBlock.getFloorZ();
        this.brokenBlock = block;
        this.upHeight -= differ;
        this.downHeight += differ;
    }

    public boolean isValid() {
        int sum = this.leaves.size() + this.blocks.size();
        return sum > 10 && (double)this.leaves.size() * 100.0 / (double)sum >= this.tree.getLeavePercent();
    }

    public boolean isTree() {
        return this.tree != null;
    }

    public boolean hitToCutDown() {
        int n;
        ++this.cutDownCount;
        return (double)n >= Math.sqrt(this.blocks.size()) * Main.config.getDouble("hit-to-cut-down", 1.0);
    }

    public boolean canBeCutDown() {
        return this.downHeight <= Main.config.getInt("count-down-blocks", 1);
    }

    public void cutDown() {
        this.tree = null;
        for (Block block : this.blocks) {
            this.level.dropItem((Vector3)block.getLocation(), Item.get((int)block.getId(), (Integer)block.getDamage()));
            block.onBreak(null);
            trees.remove(block);
        }
        for (Block block : this.leaves) {
            int[][] items = block.getDrops((Item)new ItemBlock((Block)new BlockAir(), Integer.valueOf(0), 0));
            for (int i = 0; i < items.length; ++i) {
                if (items[i][0] == 6) continue;
                this.level.dropItem((Vector3)block.getLocation(), Item.get((int)items[i][0], (Integer)items[i][1], (int)items[i][2]));
            }
            block.onBreak(null);
        }
        this.blocks.clear();
        this.leaves.clear();
    }

    public void removeBlock(Block block) {
        this.blocks.remove(block);
        trees.remove(block);
    }

    public void getBlocks(Block block) {
        int curSize;
        int step = 0;
        int size = 0;
        this.getBlocksOnHight(block, null);
        while (size != (curSize = this.blocks.size())) {
            while (size != curSize) {
                this.getBlocksOnHight(this.blocks.get(size).down(), null);
                ++size;
            }
            ++step;
        }
        this.downHeight += step;
        if (Main.config.getBoolean("check-dirt-down", true)) {
            int Y = this.blocks.get(size - 1).getFloorY();
            while (--size != -1 && this.blocks.get(size).getFloorY() == Y) {
                Block curBlock = this.blocks.get(size).down();
                if (curBlock.getId() == 2 || curBlock.getId() == 3) continue;
                this.tree = null;
                return;
            }
        }
        step = 0;
        size = this.blocks.size();
        this.getBlocksOnHight(block.up(), null);
        while (size != (curSize = this.blocks.size())) {
            while (size != curSize) {
                this.getBlocksOnHight(this.blocks.get(size).up(), null);
                ++size;
            }
            ++step;
        }
        this.upHeight = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getBlocksOnHight(Block block, BlockFace face) {
        boolean valid = this.isWoodBlock(block);
        if (valid) {
            if (this.blocks.contains(block)) return;
            this.blocks.add(block);
        } else if (this.isLeaveBlock(block)) {
            this.getLeavesOnHight(block, null);
            if (face != null) {
                return;
            }
        }
        if (!valid && face != null) return;
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            if (blockFace == face) continue;
            this.getBlocksOnHight(block.getSide(blockFace), blockFace.getOpposite());
        }
    }

    public void getLeavesOnHight(Block block, BlockFace face) {
        this.leaves.add(block);
        for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
            Block newBlock;
            if (blockFace == face || !this.isLeaveBlock(newBlock = block.getSide(blockFace)) || this.leaves.contains(newBlock)) continue;
            this.getLeavesOnHight(newBlock, blockFace.getOpposite());
        }
    }

    private boolean isWoodBlock(Block block) {
        return TreeEntity.getTree(block) == this.tree;
    }

    private boolean isLeaveBlock(Block block) {
        return TreeEntity.getTreeByLeave(block) == this.tree;
    }

    public static Type getTree(Block block) {
        for (Type treeType : Type.values()) {
            if (block.getId() != treeType.getWood() || (block.getDamage() & 3) != treeType.getWoodType()) continue;
            return treeType;
        }
        return null;
    }

    public static Type getTreeByLeave(Block block) {
        for (Type treeType : Type.values()) {
            if (block.getId() != treeType.getLeave() || (block.getDamage() & 3) != treeType.getLeaveType()) continue;
            return treeType;
        }
        return null;
    }

    public static TreeEntity GetTreeOfBlock(Block block) {
        if (trees.containsKey(block)) {
            TreeEntity tree = trees.get(block);
            tree.setBrokenBlock(block);
            return tree;
        }
        return new TreeEntity(block);
    }

    public static boolean IsBlockOfTree(Block block) {
        return block.getId() == 17 || block.getId() == 162;
    }

    public static boolean IsPlayerWithAxInHand(Player player) {
        return player.getInventory().getItemInHand().isAxe();
    }

    public static void BreakPlayerAxe(Player player) {
        PlayerInventory pInventory = player.getInventory();
        Item axe = pInventory.getItemInHand();
        if (axe.isAxe()) {
            axe.setDamage(Integer.valueOf(axe.getDamage() + Main.config.getInt("axe-durability-damage", 5)));
            if (axe.getDamage() < axe.getMaxDurability()) {
                pInventory.setItemInHand(axe);
            } else {
                pInventory.setItemInHand((Item)new ItemBlock((Block)new BlockAir(), Integer.valueOf(0), 0));
            }
        }
    }

    static enum Type {
        OAK("\u0414\u0443\u0431", new int[]{17, 0}, new int[]{18, 0}, 70.0),
        SPRUCE("\u0415\u043b\u044c", new int[]{17, 1}, new int[]{18, 1}, 50.0),
        BIRCH("\u0411\u0435\u0440\u0435\u0437\u0430", new int[]{17, 2}, new int[]{18, 2}, 70.0),
        JUNGLE("\u0421\u0435\u043a\u0432\u043e\u0439\u044f", new int[]{17, 3}, new int[]{18, 3}, 70.0),
        ACACIA("\u0410\u043a\u0430\u0446\u0438\u044f", new int[]{162, 0}, new int[]{161, 0}, 60.0),
        DARKOAK("\u0422\u0435\u043c\u043d\u044b\u0439 \u0434\u0443\u0431", new int[]{162, 1}, new int[]{161, 1}, 60.0);

        private int[] wood;
        private int[] leave;
        private double leavePercent;

        private Type(String name, int[] wood, int[] leave, double leavePercent) {
            this.wood = wood;
            this.leave = leave;
            this.leavePercent = leavePercent;
        }

        public int getWood() {
            return this.wood[0];
        }

        public int getWoodType() {
            return this.wood[1];
        }

        public int getLeave() {
            return this.leave[0];
        }

        public int getLeaveType() {
            return this.leave[1];
        }

        public double getLeavePercent() {
            return this.leavePercent;
        }
    }
}

